#import "GammaAction.h"


@implementation GammaAction

// Read the parameters from the ActionData object.
- initWithEngineData: (ActionData *)data
{
	self = [super initWithEngineData: data];
	if(self)
	{
		gamma	= [data doubleForKey: @"Gamma"];

		if(gamma < 0.01)
			gamma	= 0.01;
	}

	return self;
}


// Return the new channel values for value x.
- (void)getTransferFunction: (double *)y  at: (double)x
{
	double	p;

	if(x < 0.0)	x = 0.0;
	if(x > 1.0)	x = 1.0;

	p	= 1.0 / gamma;

	// For Red, Green, and Blue channels, just perform gamma correction.
	y[RED]		= pow(x, p);
	y[GREEN]		= pow(x, p);
	y[BLUE]		= pow(x, p);

	// For Cyan, Magenta, and Yellow channels, do a cheap approximation.
	y[CYAN]		= 1.0 - pow(1.0-x, p);
	y[MAGENTA]	= 1.0 - pow(1.0-x, p);
	y[YELLOW]		= 1.0 - pow(1.0-x, p);

	// Identity for Black and Alpha channels.
	y[BLACK]		= x;
	y[ALPHA]		= x;
}

@end
