/* bookmark.h
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Copyright (c) 1992, 1993, 1994, 1995, 1996, 1997 by Mike Gleason, NCEMRSoft.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, without modification,
 * are permitted.
 * 
 */

typedef struct Bookmark *BookmarkPtr;
typedef struct Bookmark {
	char				bookmarkName[16];
	char				name[64];
	char				user[64];	/* Leave room for user@host.name */
	char				pass[32];
	char				acct[16];
	char				dir[160];
	int				xferType;
	unsigned int			port;
	time_t				lastCall;
	int				hasSIZE;
	int				hasMDTM;
	int				hasPASV;
	int				isUnix;
	char				lastIP[32];
	char				comment[128];
	int				xferMode;
	int				hasUTIME;
} Bookmark;

#define kBookmarkVersion		8
#define kBookmarkMinVersion		3
#define kBookmarkFileName		"bookmarks"
#define kTmpBookmarkFileName		"bookmarks.tmp"
#define kOldBookmarkFileName		"hosts"
#define kBookmarkBupFileName		"bookmarks.old"

/* bookmark.c */
void BookmarkToURL(BookmarkPtr, char *, size_t);
void SetBookmarkDefaults(BookmarkPtr);
int ParseHostLine(char *, BookmarkPtr);
void CloseBookmarkFile(FILE *);
FILE *OpenBookmarkFile(void);
int GetNextBookmark(FILE *, Bookmark *);
int GetBookmark(const char *const, Bookmark *);
int PutBookmark(Bookmark *, int);
void DefaultBookmarkName(char *, size_t, char *);
