//
//  _MiscMergeForeachCommand.m
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "_MiscMergeForeachCommand.h"
#import <Foundation/NSUtilities.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSValue.h>
#import "MiscMergeCommandBlock.h"

@implementation _MiscMergeForeachCommand

- init
{
	[super init];
	commandBlock = [[MiscMergeCommandBlock alloc] initWithOwner:self];
	return self;
}

- (void)dealloc
{
	[itemName release];
	[arrayField release];
	[loopName release];
	[commandBlock release];
	[super dealloc];
}

- (BOOL)parseFromScanner:(NSScanner *)aScanner template:(MiscMergeTemplate *)template
{
	[self eatKeyWord:@"foreach" fromScanner:aScanner isOptional:NO];
	
	itemName = [[self getArgumentStringFromScanner:aScanner toEnd:NO] retain];
	arrayField = [[self getArgumentStringFromScanner:aScanner toEnd:NO] retain];
	loopName = [[self getArgumentStringFromScanner:aScanner toEnd:NO] retain];
	
	[template pushCommandBlock:commandBlock];
	
	return YES;
}

- (NSString *)loopName
{
	return loopName;
}

- (void)handleEndForeachInTemplate:(MiscMergeTemplate *)template
{
	[template popCommandBlock:commandBlock];
}

- (void)executeForMerge:(MiscMergeEngine *)aMerger
{
	id itemArray = [aMerger valueForField:arrayField];
	NSString *indexName = [NSString stringWithFormat:@"%@Index", itemName];
	int loopIndex = 0;

	if ([itemArray respondsToSelector:@selector(objectEnumerator)])
	{
		NSMutableDictionary *loopContext = [NSMutableDictionary dictionary];
		NSEnumerator *itemEnum = [itemArray objectEnumerator];
		id currObject;
		
		[aMerger addContextObject:loopContext];
		while (currObject = [itemEnum nextObject])
		{
			// maybe index should be a string
			[loopContext setObject:currObject forKey:itemName];
			[loopContext setObject:[NSNumber numberWithInt:loopIndex] forKey:indexName];
			[aMerger executeCommandBlock:commandBlock];
			loopIndex++;
		}
		[aMerger removeContextObject:loopContext];
	}
}

@end

