//
//  MiscMergeEngine.h
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import <Foundation/NSObject.h>

@class NSMutableString, NSMutableArray, NSMutableDictionary;
@class MiscMergeTemplate, MiscMergeCommand, MiscMergeCommandBlock;

@interface MiscMergeEngine : NSObject
{
	NSMutableDictionary *userInfo;
	NSMutableDictionary *engineSymbols;
	NSMutableDictionary *localSymbols;
	MiscMergeTemplate   *template;
	id              	currentObject;
	NSMutableArray  	*contextStack;
	NSMutableArray  	*commandStack;
	NSMutableString 	*outputString;
	MiscMergeEngine     *parentMerge;
	id                  driver;
	BOOL				aborted;
	BOOL				keepDelimiters;
	BOOL				useRecursiveLookups;
}

/*" Initializing "*/
- init;
- initWithTemplate:(MiscMergeTemplate *)aTemplate;

/*" Setting/getting attributes "*/
- (NSMutableDictionary *)userInfo;
- (id)mainObject;
- (MiscMergeTemplate *)template;
- (MiscMergeEngine *)parentMerge;
- (void)setMainObject:(id)anObject;
- (void)setTemplate:(MiscMergeTemplate *)aTemplate;
- (void)setParentMerge:(MiscMergeEngine *)anEngine;

/*" Manipulating context variables "*/
+ (NSMutableDictionary *)globalSymbolsDictionary;
+ (void)setGlobalValue:(id)anObject forKey:(NSString *)aKey;
+ (void)removeGlobalValueForKey:(NSString *)aKey;
+ (id)globalValueForKey:(NSString *)aKey;
- (void)setGlobalValue:(id)anObject forKey:(NSString *)aKey;
- (void)removeGlobalValueForKey:(NSString *)aKey;
- (id)globalValueForKey:(NSString *)aKey;

- (void)setEngineValue:(id)anObject forKey:(NSString *)aKey;
- (void)removeEngineValueForKey:(NSString *)aKey;
- (id)engineValueForKey:(NSString *)aKey;

- (void)setLocalValue:(id)anObject forKey:(NSString *)aKey;
- (void)removeLocalValueForKey:(NSString *)aKey;
- (id)localValueForKey:(NSString *)aKey;


/*" Executing the merge "*/
- (NSString *)execute:sender;
- (NSString *)executeWithObject:(id)anObject sender:sender;

/*" Getting the output "*/
- (NSString *)outputString;

/*" Primitives that may be used by MiscMergeCommands "*/
- (void)executeCommand:(MiscMergeCommand *)command;
- (void)executeCommandBlock:(MiscMergeCommandBlock *)block;
- (void)addContextObject:(id)anObject;
- (void)removeContextObject:(id)anObject;
- (id)valueForField:(NSString *)fieldName;
- (void)appendToOutput:(NSString *)aString;
- (void)abortMerge;
- (void)advanceRecord;

@end
