/* FoundationAdditions.h created by lindberg on Mon 20-Dec-1999 */

#import <Foundation/NSArray.h>
#import <Foundation/NSString.h>
#import <Foundation/NSFileManager.h>

/* Various Foundation methods for use by templates and/or EOGenerator */

@interface NSArray (EOGenerator)

- (NSArray *)reversedArray;

// Key-value additions (i.e. @reversedArray, @sortedNameArray, etc. keys)
- (id)computeReversedArrayForKey:(NSString *)key;
- (id)computeSortedNameArrayForKey:(NSString *)key;
- (id)computeSortedStringArrayForKey:(NSString *)key;

@end

@interface NSString (EOGenerator)

- (NSString *)initialCapitalString;

@end

@interface NSFileManager (EOGenerator)

- (BOOL)directoryExistsAtPath:(NSString *)path;
- (BOOL)regularFileExistsAtPath:(NSString *)path;
- (NSString *)findFile:(NSString *)filename inSearchPath:(NSArray *)paths;
- (void)touchPath:(NSString *)filePath;

@end
