/* MLSystemInformation.m created by mlaster on Thu 13-Nov-1997 */

#import "MLSystemInformation.h"

NSString * performanceUpdateNotification = @"performanceUpdateNotification";

@implementation MLSystemInformation

- (id) init
{
    return [self initWithInterval:1.0];
}

- (id) initWithInterval:(NSTimeInterval)anInterval
{
    NSTimer *myTimer;
    
    self = [super init];
    if (self != nil)
    {
        myTimer = [NSTimer scheduledTimerWithTimeInterval:anInterval
                                                   target:self
                                                 selector:@selector(timerTick:)
                                                 userInfo:self
                                                  repeats:YES];
    }
    return self;
}

- (void) dealloc
{
    [self setTimer:nil];
    [super dealloc];
}

// accessor methods
- (void) setTimer:(NSTimer *)newTimer
{
    // NSTimer's are a special-case for retain/release logic.  The NSRunLoop controls the lifetime of the object.
    // It will automatically go away when it's usefulness is done.
    if (timer != newTimer)
    {
        [timer invalidate];
        timer = newTimer;
    }
}

- (NSTimer *) timer
{
    return timer;
}

- (double) runQueue1
{
    return (double)load_info.avenrun[0] / LOAD_SCALE;
}
- (double) runQueue5
{
    return (double)load_info.avenrun[1] / LOAD_SCALE;
}
- (double) runQueue15
{
    return (double)load_info.avenrun[2] / LOAD_SCALE;
}
- (double) machFactor1
{
    return (double)load_info.mach_factor[0] / LOAD_SCALE;
}
- (double) machFactor5
{
    return (double)load_info.mach_factor[1] / LOAD_SCALE;
}
- (double) machFactor15
{
    return (double)load_info.mach_factor[2] / LOAD_SCALE;
}

- (void) timerTick:(NSInvocation *)anInvocation
{
    [self retreiveLoadInformation];
    [[NSNotificationCenter defaultCenter] postNotificationName:performanceUpdateNotification object:self];
}

- (void) retreiveLoadInformation
{
    kern_return_t ret;
    unsigned int count=HOST_LOAD_INFO_COUNT;

    ret = host_info(host_self(), HOST_LOAD_INFO, (host_info_t)&load_info, &count);
    NSAssert(ret == KERN_SUCCESS, @"host_info() call failed");
}

@end
