/*+++*
 *  title:	re.h
 *  abstract:	OPENSTEP/Rhapsody regex compatibility for mailapp-utilities. 
 *  author:	Tom Hageman <tom@basil.icce.rug.nl>
 *  created:	August 1998
 *  modified:	
 *  copyleft:
 *
 *	Copyright (C) 1998 Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *	drop-in replacement for NEXTSTEP / OPENSTEPs old regular expression
 *	matcher, implemented in terms of RHAPSODYs POSIX regexp.
 *---*/

#ifdef RCS_re_ID
static const char * const RCS_h_id = ((void)&RCS_h_id,
	"@(#)re.h,v 1.1 1998/08/07 23:58:10");
#endif

#import <regex.h>
#import "compat.h"

#if RHAPSODY

#define NBRA	9

struct regex {
	regex_t	regex;
	const char *braslist[NBRA];
	const char *braelist[NBRA];
	const char *start, *end;
};

extern struct regex *re_compile(const char *string, int fold);
extern int re_match(const char *string, struct regex *r);

#endif /* RHAPSODY */

void re_free(struct regex *r);
