/*+++*
 *  title:	re.c
 *  abstract:	OPENSTEP/Rhapsody regex compatibility for mailapp-utilities. 
 *  author:	Tom Hageman <tom@basil.icce.rug.nl>
 *  created:	August 1998
 *  modified:	
 *  copyleft:
 *
 *	Copyright (C) 1998 Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *	(see corresponding *.h file)
 *---*/

static const char * const RCSid = ((void)&RCSid,
	"@(#)re.c,v 1.2 1998/08/10 13:47:21");
#define RCS_re_H

#include <stdio.h>
#include <stdlib.h>
#include "re.h"


#if (RHAPSODY)

struct regex *re_compile(const char *string, int fold)
{
   struct regex *r = malloc(sizeof(struct regex));

   if (r)
   {
      int st = regcomp(&r->regex, string, fold ? REG_BASIC|REG_ICASE : REG_BASIC);

      if (st != 0)
      {
	 char buf[BUFSIZ];

	 regerror(st, &r->regex, buf, sizeof(buf));
	 fprintf(stderr, "regcomp error: %s, for \"%s\"\n", buf, string);
	 free(r), r = NULL;
      }
   }
   return r;
}

int re_match(const char *string, struct regex *r)
{
   regmatch_t pm[NBRA+1];
   int i;

   if (r == NULL || string == NULL) return 0;

   if (regexec(&r->regex, string, NBRA+1, pm, 0) != 0) return 0;

   r->start = string + pm[0].rm_so;
   r->end = string + pm[0].rm_eo;

   for (i = NBRA;  i > 0;  --i)
   {
      r->braslist[i-1] = pm[i].rm_so == -1 ? NULL : string + pm[i].rm_so;
      r->braelist[i-1] = pm[i].rm_eo == -1 ? NULL : string + pm[i].rm_eo;
   }
   return 1;
}

void re_free(struct regex *r)
{
   if (r) regfree(&r->regex);
   free(r);
}

#else /* RHAPSODY */

void re_free(struct regex *r)
{
   free(r);
}

#endif /* RHAPSODY */
