/* -*-C-*-
*******************************************************************************
*
* File:         mailutil.h
* RCS:          /usr/local/sources/CVS/mailapp-utilities/mailutil.h,v 1.10 1998/11/21 23:54:10 tom Exp
* Description:  Header file for all Mail.app utilities
* Author:       Carl Edman
* Created:      Sun Apr 25 10:27:09 1993
* Modified:     Sat Nov 21 19:19:41 1998 Tom Hageman <tom@basil.icce.rug.nl>
* Language:     C
* Package:      mailapp-utilities
* Status:       Exp
*
* (C) Copyright 1993, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "compat.h"
#import <sys/types.h>
#import <time.h>

#if RHAPSODY
#  define MAIL_APP   "MailViewer"
#else
#  define MAIL_APP   "Mail"
#endif

#define LINELEN 10240

int mailboxdir(char *buf);
int cd_mbox(const char *name,int createflag);
int uncd_mbox(void);

int try_lock_mbox_file(const char *lockfile,char *lockhost,char *lockuser,int *lockpid);
int lock_mbox_file(const char *lockfile, int nowaitflg);
int unlock_mbox_file(const char *lockfile);
int try_lock_mbox(char *lockhost,char *lockuser,int *lockpid);
int lock_mbox(int nowaitflg);
int unlock_mbox(void);

#define LOCK_USER_FMT	"%s\320[%s]"
#define LOCK_USER_RE	"\\(.*\\)\320\\[\\(.*\\)\\]"

time_t mtime(const char *path);
off_t filesize(const char *path);
int dirsize(char *path);

char *strpcpy(char *to,const char *beg,const char *end);
char *strpcat(char *to,const char *beg,const char *end);
int strpequ(char *to,const char *beg,const char *end);
int strpcaseequ(char *to,const char *beg,const char *end);

void appstring(char **string,int *len,int *maxlen,const char *app,const int alen);
char *growstring(char **string,int *len,int *maxlen,const int alen);

unsigned long int calc_crc(const char *beg,int len);

void forall_mboxes(void (*func)(const char *));
