# Begin TickleServices Version 1.02mab Data
"Divider" = "196.000000";
"Menu Item" = "!Initialization!";
"Tcl" = "\
    # This version of exec doesn't strip the trailing newline from th\
e
    # output.
proc nexec {args} {
    set fileId [uplevel open [list [format \"|%s\" $args]]]
    set ret [read $fileId]
    close $fileId
    return $ret
}

    # Reads the specified file and returns the text.
proc readfile {filename {hexcode 0}} {
    set fileId [open $filename r]
    if {$hexcode} {
        set ret [read -hexcode $fileId]
    } else {
        set ret [read $fileId]
    }
    close $fileId
    return $ret
}

    # Writes the text to the specified file.
proc writefile {filename text {hexcode 0}} {
    set fileId [open $filename w]
    if {$hexcode} {
        set ret [puts -nonewline -hexcode $fileId $text]
    } else {
        set ret [puts -nonewline $fileId $text]
    }
    close $fileId
    return $ret
}

    # read the quoteString from the defaults database.  The quoteStri\
ng
    # defaults to \">\", which is a semi-standard quoting character.
global quoteString
set quoteString [defaults read TickleServices QuoteString \">\"]

    # Ditto for the maximum length of text lines
global lineLength
set lineLength [defaults read Mail LineLength 72]

proc prepend {str prefix} {
    set str [string trimright \"\\n$str\" \"\\n\"]    
    regsub -all \"\\n\" $str \"\\n[escape $prefix {\\\\&\\[\\]}]\" st\
r
    return \"[string range $str 1 end]\\n\"
}

proc unprepend {str prefix} {
    set str \"\\n$str\"
    regsub -all \"\\n[escape $prefix {\\\\&\\[\\]}]\" $str \"\\n\" st\
r
    return [string range $str 1 end]
}

proc refmt {str ll} {
   set out \"\"
   set pos 0
   set prefix \"\"
   regsub -all \"\\t\" $str \"        \" str
   foreach line [split [string trim $str \"\\n\"] \"\\n\"] {
      regexp \"^(\\[ >\\]*)(.*)$\" $line line nprefix text
      if {$prefix!=$nprefix} {
	 if {$pos!=0} {append out \"\\n\"}
         set prefix $nprefix
	 set pos 0
	 }
      if {$text==\"\"} {
         if {$pos!=0} {append out \"\\n\"}
         append out \"$prefix\\n\"
	 set pos 0
	 continue
      }
      foreach word [split $text \" \"] {
        if {$pos==0 || $pos+1+[string length $word] >= $ll} {
	   if {$word==\"\"} continue
	   if {$pos>0} {append out \"\\n\"}
	   append out $prefix
	   set pos [string length $prefix]
	   append out $word
	   incr pos [string length $word]
	} else {
	   append out \" \"
	   incr pos
	   append out $word
	   incr pos [string length $word]
	} } }
   if {$pos!=0} { append out \"\\n\" }
   return $out
}

    # This is a dis-gusting procedure to convert a Text-style RTF
    # string with attachments into a Mail2.1-style RTF string with
    # attachments.  The basic problem this routine solves is that
    # where Edit stores attachments as
    #     {...{\\NeXTGraphic# attachmentName \\width# \\height#\\n}..\
.},
    # Mail stores them as {{\\attachment# attachmentName\\n}\\n}.
    # The attachmentName and the first # (which gives the position
    # of the attachment in the text) must be extracted and placed
    # in their new home.  Furthermore, the attachmentName must be
    # expanded to and absolute pathname.
proc convertRTF2x {textStyle filename} {
    set addin 0
    while {[regexp \"{\\[^{\\]*{\\\\\\\\NeXTGraphic(\\[0-9\\]*) (\\[^\
\\n\\]*) \\\\\\\\width\\[0-9\\]* \\\\\\\\height\\[0-9\\]*\\n}\\[^}\\]\
*}\" $textStyle directive position attachment]} {
	set esc [escape $directive \"|*+?.^\\$\\\\\\[\\]\"]
	
	    # Add in an adjustment because Edit counts the graphic
	    # as a character, whereas Mail does not, so the Edit
	    # position must be adjusted downward for each graphic.
	incr position $addin
	incr addin -1
	set rep [escape \"{{\\\\attachment$position $filename/$attachment\\n\
}\\n}\" \"\\\\&\"]
	if {![regsub -all $esc $textStyle $rep textStyle]} {
		# It _must_ have replaced a directive, since we
		# found one.  This is an attempt to prevent infinite
		# loops caused by never replacing what we found in
		# regexp.
	    error \"Unable to process RTF directive\"
	}
    }
    return $textStyle
}

proc convertRTF30 {textStyle filename} {
    regsub -all \"({\\\\\\\\NeXTGraphic\\[0-9\\]* *)(\\[^\\n\\]* \\\\\
\\\\width\\[0-9\\]* \\\\\\\\height\\[0-9\\]*\\n})\" $textStyle \"\\\\\
1$filename/\\\\2\" textStyle
    return $textStyle
}

proc convertRTF {textStyle filename} {
    return $textStyle
}";
"Window Size" = "{ 728.000, 364.000}";
|
"Menu Item" = "MyMail/Deliver";
"Send Type" = "NXAsciiPboardType";
"Tcl" = "\
# Call sendmail to write the passed data to the user's mailbox.

if {![info exists whoami]} {
    set whoami [exec /usr/ucb/whoami]
}
exec /usr/lib/sendmail $whoami << [pasteboard read]
";
|
"Key Equivalent" = "F";
"Menu Item" = "MyMail/Format Text";
"Receive Type" = "NXAsciiPboardType";
"Send Type" = "NXAsciiPboardType";
"Tcl" = "\
# Reformat the selection to less than $lineLength columns.

pasteboard write [refmt [pasteboard read] $lineLength]
";
|
"Key Equivalent" = "I";
"Menu Item" = "MyMail/Insert Signature";
"Receive Type" = "NXAsciiPboardType";
"Receive Type" = "NXRTFPboardType";
"Tcl" = "\
# Return text of ASCII and/or RTF signature file.

# Get the signature file default 
set asciiSigFile [defaults read TickleServices SignatureFile ~/.signa\
ture]
if {[file exists $asciiSigFile]} {
   set asciiSig \"---\\n[readfile [glob $asciiSigFile]]\"
} else { set asciiSig \"\" }

set rtfSigFile [defaults read TickleServices RTFSignatureFile ~/.sign\
ature.rtf]
if {[file exists $rtfSigFile]} {
  if {[file isdirectory $rtfSigFile]} {
    set rtfSig [convertRTF [readfile $rtfSigFile/TXT.rtf] $rtfSigFile\
]
    puts stdout $rtfSig
  } else { set rtfSig [readfile [glob $rtfSigFile]] }
} else { set rtfSig \"\" }

if {$rtfSig!=\"\" && $asciiSig!=\"\"} {
  pasteboard declare $NXRTFPboardType $NXAsciiPboardType
  pasteboard write $rtfSig $NXRTFPboardType
  pasteboard write $asciiSig $NXAsciiPboardType
} elseif {$rtfSig!=\"\"} {
  pasteboard write $rtfSig $NXRTFPboardType
} elseif {$asciiSig!=\"\"} {
  pasteboard write $asciiSig $NXAsciiPboardType
} else {
  alertpanel {Insert Signature} \"Unable to find `$asciiSigFile' or `\
$rtfSigFile'.\"
}
";
|
"Key Equivalent" = ">";
"Menu Item" = "MyMail/Quote Text";
"Receive Type" = "NXAsciiPboardType";
"Send Type" = "NXAsciiPboardType";
"Tcl" = "\
# Quote the selection with the default quoteString.  See !Initializat\
ion!
# for info on quoteString.

pasteboard write [refmt [prepend [pasteboard read] $quoteString] $lin\
eLength]

";
|
"Key Equivalent" = "R";
"Menu Item" = "MyMail/Reply Text";
"Send Type" = "NeXTmail Message pasteboard type";
"Tcl" = "\
set mail [exec /usr/bin/rtf-ascii << [pasteboard read $NXRTFPboardTyp\
e]]
set pos [string first \"\\n\\n\" $mail]
set header \"\\n[string range $mail 0 [expr {$pos}]]\"
regexp \"\\nFrom: (\\[^\\n\\]*)\\n\" $header null from
regexp \"\\nSubject: (\\[^\\n\\]*)\\n\" $header null subject

if {[regexp \"^R\\[Ee\\]: \" $subject]==0} { set subject \"Re: $subje\
ct\" }

exec /usr/local/bin/nextmail -e -s \"$subject\" $from << [refmt [prep\
end [string range $mail [expr {$pos+2}] end] $quoteString] $lineLengt\
h]
";
|
"Menu Item" = "MyMail/Set Quote String";
"Send Type" = "NXAsciiPboardType";
"Tcl" = "\
# Set the default quoteString.

    # In general quote strings shouldn't contain newlines.
if {[string first \"\\n\" [pasteboard read]]!=-1} {
    if {[alertpanel \"Set Quote String\" \"Selected quote string cont\
ains one or more newlines.  Are you certain you wish to use this quot\
e string?\" \"Cancel\" \"OK\"]==1} {
        return
    }
}

    # Set the current value, and also the default for future use.
set quoteString [pasteboard read]
defaults write TickleServices QuoteString $quoteString
";
|
"Menu Item" = "MyMail/Set Signature";
"Send Type" = "NXAsciiPboardType";
"Send Type" = "NXRTFPboardType";
"Tcl" = "\
# Set the signature.

if {[lindex [pasteboard types] 0]==$NXRTFPboardType} {
   set sigFile [defaults read TickleServices RTFSignatureFile ~/.sign\
ature.rtf] 
   set sigType $NXRTFPboardType
   } else {
   set sigFile [defaults read TickleServices SignatureFile ~/.signatu\
re]
   set sigType $NXAsciiPboardType
   }

    # Get the signature file default and glob it to make it absolute.
set globFile [glob $sigFile]

    # Give the user a last change before overwriting the file.
if {[file exists $globFile]} {
    if {[alertpanel {Set Signature} \"Overwrite current signature in \
$sigFile?\" {OK} {Cancel}]!=1} {
	return
    }
	# Still, what if they might want it back?  Back it up.
    catch {exec mv $globFile $globFile~}
}

    # Write the signature file from the pasteboard.
writefile $globFile [pasteboard read $sigType]
";
|
"Key Equivalent" = "<";
"Menu Item" = "MyMail/Unquote Text";
"Receive Type" = "NXAsciiPboardType";
"Send Type" = "NXAsciiPboardType";
"Tcl" = "\
# Unquote the selection with the default quoteString.  See !Initializ\
ation!
# for info on quoteString.

pasteboard write [refmt [unprepend [pasteboard read] $quoteString] $l\
ineLength]
";
# End TickleServices Data
