/*+++
 *  title:      MailViewerProxy.m
 *  abstract:   Implementation of MailViewerProxy class for mailapp-utilities.
 *  author:     Tom Hageman <tom@basil.icce.rug.nl>
 *  created:    October 1998
 *  modified:   
 *  copyleft:
 *
 *	Copyright (C) 1998  Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *
 *      Private concrete MailProxy subclass.
 *	Implements communication with MailViewer.app (and, possibly, other
 *	mail clients that implement <MVDOServer> protocol on Rhapsody.)
 *	
 *---*/

static const char * const RCSid = ((void)&RCSid,
	"@(#)MailViewerProxy.m,v 1.6 1998/12/02 00:27:58 tom Exp");
#define RCS_MailAppProxy_ID

#import "MailProxy.h"
#import "mailutil.h"
#import <string.h>
#import <stdlib.h>

#if NEXTSTEP
 #error MailViewer.app proxy not supported on NEXTSTEP.
#endif


// Undocumented DO protocol from MailViewer
@protocol MVDOServer <NSObject>
- (oneway void)newComposeWindowWithHeaders:(bycopy NSDictionary *)headers
	body:(bycopy NSAttributedString *)body;
@end

#define MVDO_NAME_FORMAT	@"%@ DO Server-%@" // mailer, username


@interface MailViewerProxy : MailProxy
{
   id <MVDOServer> server;
}

@end // MailViewerProxy


@implementation MailViewerProxy

+ (BOOL)canEditMessage		{ return YES; }
//+ (BOOL)canDeliverMessage	{ return NO; }
//+ (BOOL)canIncorporateNewMail	{ return NO; }
+ (BOOL)canSendBcc		{ return YES; }
+ (BOOL)canSendArbitraryHeaders	{ return YES; }

- (void)dealloc
{
   [server release];
   [super dealloc];
}


- (BOOL)connectToMailer
{
   NSString *name = [NSString stringWithFormat:MVDO_NAME_FORMAT,
			[self mailerName], NSUserName()];
   NSString *host = [self hostName];
   id proxy;

   proxy = [NSConnection rootProxyForConnectionWithRegisteredName:name host:host];

   if (proxy == nil) return NO;

   [proxy setProtocolForProxy:@protocol(MVDOServer)];
   server = [proxy retain];
   return YES;
}

- (BOOL)sendMailBody:(id)body headers:(NSDictionary *)headers
{
   NS_DURING
   {
      body = [self replacementObjectForBody:body];
      [server newComposeWindowWithHeaders:headers body:body];
      [self makeMailerActive];
   }
   NS_HANDLER
   {
      return NO;
   }
   NS_ENDHANDLER

   return isConnected;
}


- (id)replacementObjectForBody:(id)body
{
   // RDR2 MVDOServer expects Attributed String, but refuses to work if
   // attributes are actually present...
   if (body/* && ![body isKindOfClass:[NSAttributedString class]]*/)
   {
      if ((body = [super replacementObjectForBody:body]) != nil)
      {
	 body = [[[NSAttributedString alloc] initWithString:body] autorelease];
      }
   }
   return body;
}

@end // MailViewerProxy
