
#import "MailProxy+Convenience.h"


@implementation MailProxy (NEXTSTEPConvenience)

+ (Class)classForMailer:(const char *)aMailer
{
    return [self classForMailer:aMailer directDelivery:NO incorporation:NO];
}

+ (Class)classForMailer:(const char *)aMailer directDelivery:(BOOL)direct
{
    return [self classForMailer:aMailer directDelivery:direct incorporation:NO];
}

+ (Class)classForMailer:(const char *)aMailer incorporation:(BOOL)incorporate
{
    return [self classForMailer:aMailer directDelivery:NO incorporation:incorporate];
}


+ newForMailer:(const char *)aMailer
{
    return [self newForMailer:aMailer host:NULL forceLaunch:YES directDelivery:NO incorporation:NO];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:YES directDelivery:NO incorporation:NO];
}

+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force
{
    return [self newForMailer:aMailer host:NULL forceLaunch:force directDelivery:NO incorporation:NO];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:force directDelivery:NO incorporation:NO];
}

+ newForMailer:(const char *)aMailer directDelivery:(BOOL)direct
{
    return [self newForMailer:aMailer host:NULL forceLaunch:YES directDelivery:direct incorporation:NO];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName directDelivery:(BOOL)direct
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:YES directDelivery:direct incorporation:NO];
}

+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct
{
    return [self newForMailer:aMailer host:NULL forceLaunch:force directDelivery:direct incorporation:NO];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force directDelivery:(BOOL)direct
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:force directDelivery:direct incorporation:NO];
}

+ newForMailer:(const char *)aMailer incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:NULL forceLaunch:YES directDelivery:NO incorporation:incorporate];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:YES directDelivery:NO incorporation:incorporate];
}

+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:NULL forceLaunch:force directDelivery:NO incorporation:incorporate];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:force directDelivery:NO incorporation:incorporate];
}

+ newForMailer:(const char *)aMailer directDelivery:(BOOL)direct incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:NULL forceLaunch:YES directDelivery:direct incorporation:incorporate];
}

+ newForMailer:(const char *)aMailer host:(const char *)aHostName directDelivery:(BOOL)direct incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:aHostName forceLaunch:YES directDelivery:direct incorporation:incorporate];
}

+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct incorporation:(BOOL)incorporate
{
    return [self newForMailer:aMailer host:NULL forceLaunch:force directDelivery:direct incorporation:incorporate];
}


- initForMailer:(const char *)aMailer
{
    return [self initForMailer:aMailer host:NULL forceLaunch:YES directDelivery:NO];
}

- initForMailer:(const char *)aMailer host:(const char *)aHostName
{
    return [self initForMailer:aMailer host:aHostName forceLaunch:YES directDelivery:NO];
}

- initForMailer:(const char *)aMailer forceLaunch:(BOOL)force
{
    return [self initForMailer:aMailer host:NULL forceLaunch:force directDelivery:NO];
}

- initForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force
{
    return [self initForMailer:aMailer host:aHostName forceLaunch:force directDelivery:NO];
}

- initForMailer:(const char *)aMailer directDelivery:(BOOL)direct
{
    return [self initForMailer:aMailer host:NULL forceLaunch:YES directDelivery:direct];
}

- initForMailer:(const char *)aMailer host:(const char *)aHostName directDelivery:(BOOL)direct
{
    return [self initForMailer:aMailer host:aHostName forceLaunch:YES directDelivery:direct];
}

- initForMailer:(const char *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct
{
    return [self initForMailer:aMailer host:NULL forceLaunch:force directDelivery:direct];
}


- (BOOL)sendMailTo:(const char *)to
{
    return [self sendMailTo:to subject:NULL body:NULL cc:NULL bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject
{
    return [self sendMailTo:to subject:subject body:NULL cc:NULL bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to body:(const char *)body
{
    return [self sendMailTo:to subject:NULL body:body cc:NULL bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject body:(const char *)body
{
    return [self sendMailTo:to subject:subject body:body cc:NULL bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to cc:(const char *)cc
{
    return [self sendMailTo:to subject:NULL body:NULL cc:cc bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject cc:(const char *)cc
{
    return [self sendMailTo:to subject:subject body:NULL cc:cc bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to body:(const char *)body cc:(const char *)cc
{
    return [self sendMailTo:to subject:NULL body:body cc:cc bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject body:(const char *)body cc:(const char *)cc
{
    return [self sendMailTo:to subject:subject body:body cc:cc bcc:NULL];
}

- (BOOL)sendMailTo:(const char *)to bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:NULL body:NULL cc:NULL bcc:bcc];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:subject body:NULL cc:NULL bcc:bcc];
}

- (BOOL)sendMailTo:(const char *)to body:(const char *)body bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:NULL body:body cc:NULL bcc:bcc];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject body:(const char *)body bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:subject body:body cc:NULL bcc:bcc];
}

- (BOOL)sendMailTo:(const char *)to cc:(const char *)cc bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:NULL body:NULL cc:cc bcc:bcc];
}

- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject cc:(const char *)cc bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:subject body:NULL cc:cc bcc:bcc];
}

- (BOOL)sendMailTo:(const char *)to body:(const char *)body cc:(const char *)cc bcc:(const char *)bcc
{
    return [self sendMailTo:to subject:NULL body:body cc:cc bcc:bcc];
}

@end // MailProxy (NEXTSTEPConvenience)



#if !NEXTSTEP

@implementation MailProxy (OPENSTEPConvenience)

+ classWithMailer:(NSString *)aMailer
{
    return [self classWithMailer:aMailer directDelivery:NO incorporation:NO];
}

+ classWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct
{
    return [self classWithMailer:aMailer directDelivery:direct incorporation:NO];
}

+ classWithMailer:(NSString *)aMailer incorporation:(BOOL)incorporate
{
    return [self classWithMailer:aMailer directDelivery:NO incorporation:incorporate];
}


+ mailProxyWithMailer:(NSString *)aMailer
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:YES directDelivery:NO incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:YES directDelivery:NO incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:force directDelivery:NO incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:force directDelivery:NO incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:YES directDelivery:direct incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName directDelivery:(BOOL)direct
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:YES directDelivery:direct incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:force directDelivery:direct incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force directDelivery:(BOOL)direct
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:force directDelivery:direct incorporation:NO];
}

+ mailProxyWithMailer:(NSString *)aMailer incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:YES directDelivery:NO incorporation:incorporate];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:YES directDelivery:NO incorporation:incorporate];
}

+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:force directDelivery:NO incorporation:incorporate];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:force directDelivery:NO incorporation:incorporate];
}

+ mailProxyWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:YES directDelivery:direct incorporation:incorporate];
}

+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName directDelivery:(BOOL)direct incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:aHostName forceLaunch:YES directDelivery:direct incorporation:incorporate];
}

+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct incorporation:(BOOL)incorporate
{
    return [self mailProxyWithMailer:aMailer host:NULL forceLaunch:force directDelivery:direct incorporation:incorporate];
}


- initWithMailer:(NSString *)aMailer
{
    return [self initWithMailer:aMailer host:NULL forceLaunch:YES directDelivery:NO];
}

- initWithMailer:(NSString *)aMailer host:(NSString *)aHostName
{
    return [self initWithMailer:aMailer host:aHostName forceLaunch:YES directDelivery:NO];
}

- initWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force
{
    return [self initWithMailer:aMailer host:NULL forceLaunch:force directDelivery:NO];
}

- initWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force
{
    return [self initWithMailer:aMailer host:aHostName forceLaunch:force directDelivery:NO];
}

- initWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct
{
    return [self initWithMailer:aMailer host:NULL forceLaunch:YES directDelivery:direct];
}

- initWithMailer:(NSString *)aMailer host:(NSString *)aHostName directDelivery:(BOOL)direct
{
    return [self initWithMailer:aMailer host:aHostName forceLaunch:YES directDelivery:direct];
}

- initWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct
{
    return [self initWithMailer:aMailer host:NULL forceLaunch:force directDelivery:direct];
}


- (BOOL)sendMailMessageTo:(NSString *)to
{
    return [self sendMailMessageTo:to subject:nil body:nil cc:nil bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject
{
    return [self sendMailMessageTo:to subject:subject body:nil cc:nil bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body
{
    return [self sendMailMessageTo:to subject:nil body:body cc:nil bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject body:(id)body
{
    return [self sendMailMessageTo:to subject:subject body:body cc:nil bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to cc:(NSString *)cc
{
    return [self sendMailMessageTo:to subject:nil body:nil cc:cc bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject cc:(NSString *)cc
{
    return [self sendMailMessageTo:to subject:subject body:nil cc:cc bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body cc:(NSString *)cc
{
    return [self sendMailMessageTo:to subject:nil body:body cc:cc bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject body:(id)body cc:(NSString *)cc
{
    return [self sendMailMessageTo:to subject:subject body:body cc:cc bcc:nil];
}

- (BOOL)sendMailMessageTo:(NSString *)to bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:nil body:nil cc:nil bcc:bcc];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:subject body:nil cc:nil bcc:bcc];
}

- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:nil body:body cc:nil bcc:bcc];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject body:(id)body bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:subject body:body cc:nil bcc:bcc];
}

- (BOOL)sendMailMessageTo:(NSString *)to cc:(NSString *)cc bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:nil body:nil cc:cc bcc:bcc];
}

- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject cc:(NSString *)cc bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:subject body:nil cc:cc bcc:bcc];
}

- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body cc:(NSString *)cc bcc:(NSString *)bcc
{
    return [self sendMailMessageTo:to subject:nil body:body cc:cc bcc:bcc];
}

@end // MailProxy (OPENSTEPConvenience)

#endif // !NEXTSTEP
