
#import "MailProxy.h"

@interface MailProxy (NEXTSTEPConvenience)
+ (Class)classForMailer:(const char *)aMailer;
+ (Class)classForMailer:(const char *)aMailer directDelivery:(BOOL)direct;
+ (Class)classForMailer:(const char *)aMailer incorporation:(BOOL)incorporate;

+ newForMailer:(const char *)aMailer;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName;
+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force;
+ newForMailer:(const char *)aMailer directDelivery:(BOOL)direct;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName directDelivery:(BOOL)direct;
+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force directDelivery:(BOOL)direct;
+ newForMailer:(const char *)aMailer incorporation:(BOOL)incorporate;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName incorporation:(BOOL)incorporate;
+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force incorporation:(BOOL)incorporate;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force incorporation:(BOOL)incorporate;
+ newForMailer:(const char *)aMailer directDelivery:(BOOL)direct incorporation:(BOOL)incorporate;
+ newForMailer:(const char *)aMailer host:(const char *)aHostName directDelivery:(BOOL)direct incorporation:(BOOL)incorporate;
+ newForMailer:(const char *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct incorporation:(BOOL)incorporate;

- initForMailer:(const char *)aMailer;
- initForMailer:(const char *)aMailer host:(const char *)aHostName;
- initForMailer:(const char *)aMailer forceLaunch:(BOOL)force;
- initForMailer:(const char *)aMailer host:(const char *)aHostName forceLaunch:(BOOL)force;
- initForMailer:(const char *)aMailer directDelivery:(BOOL)direct;
- initForMailer:(const char *)aMailer host:(const char *)aHostName directDelivery:(BOOL)direct;
- initForMailer:(const char *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct;

- (BOOL)sendMailTo:(const char *)to;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject;
- (BOOL)sendMailTo:(const char *)to body:(const char *)body;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject body:(const char *)body;
- (BOOL)sendMailTo:(const char *)to cc:(const char *)cc;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject cc:(const char *)cc;
- (BOOL)sendMailTo:(const char *)to body:(const char *)body cc:(const char *)cc;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject body:(const char *)body cc:(const char *)cc;
- (BOOL)sendMailTo:(const char *)to bcc:(const char *)bcc;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject bcc:(const char *)bcc;
- (BOOL)sendMailTo:(const char *)to body:(const char *)body bcc:(const char *)bcc;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject body:(const char *)body bcc:(const char *)bcc;
- (BOOL)sendMailTo:(const char *)to cc:(const char *)cc bcc:(const char *)bcc;
- (BOOL)sendMailTo:(const char *)to subject:(const char *)subject cc:(const char *)cc bcc:(const char *)bcc;
- (BOOL)sendMailTo:(const char *)to body:(const char *)body cc:(const char *)cc bcc:(const char *)bcc;
@end // MailProxy (NEXTSTEPConvenience)

#if !NEXTSTEP
@interface MailProxy (OPENSTEPConvenience)
+ classWithMailer:(NSString *)aMailer;
+ classWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct;
+ classWithMailer:(NSString *)aMailer incorporation:(BOOL)incorporate;

+ mailProxyWithMailer:(NSString *)aMailer;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName;
+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force;
+ mailProxyWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName directDelivery:(BOOL)direct;
+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force directDelivery:(BOOL)direct;
+ mailProxyWithMailer:(NSString *)aMailer incorporation:(BOOL)incorporate;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName incorporation:(BOOL)incorporate;
+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force incorporation:(BOOL)incorporate;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force incorporation:(BOOL)incorporate;
+ mailProxyWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct incorporation:(BOOL)incorporate;
+ mailProxyWithMailer:(NSString *)aMailer host:(NSString *)aHostName directDelivery:(BOOL)direct incorporation:(BOOL)incorporate;
+ mailProxyWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct incorporation:(BOOL)incorporate;

- initWithMailer:(NSString *)aMailer;
- initWithMailer:(NSString *)aMailer host:(NSString *)aHostName;
- initWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force;
- initWithMailer:(NSString *)aMailer host:(NSString *)aHostName forceLaunch:(BOOL)force;
- initWithMailer:(NSString *)aMailer directDelivery:(BOOL)direct;
- initWithMailer:(NSString *)aMailer host:(NSString *)aHostName directDelivery:(BOOL)direct;
- initWithMailer:(NSString *)aMailer forceLaunch:(BOOL)force directDelivery:(BOOL)direct;

- (BOOL)sendMailMessageTo:(NSString *)to;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject;
- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject body:(id)body;
- (BOOL)sendMailMessageTo:(NSString *)to cc:(NSString *)cc;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject cc:(NSString *)cc;
- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body cc:(NSString *)cc;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject body:(id)body cc:(NSString *)cc;
- (BOOL)sendMailMessageTo:(NSString *)to bcc:(NSString *)bcc;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject bcc:(NSString *)bcc;
- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body bcc:(NSString *)bcc;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject body:(id)body bcc:(NSString *)bcc;
- (BOOL)sendMailMessageTo:(NSString *)to cc:(NSString *)cc bcc:(NSString *)bcc;
- (BOOL)sendMailMessageTo:(NSString *)to subject:(NSString *)subject cc:(NSString *)cc bcc:(NSString *)bcc;
- (BOOL)sendMailMessageTo:(NSString *)to body:(id)body cc:(NSString *)cc bcc:(NSString *)bcc;
@end // MailProxy (OPENSTEPConvenience)

#endif // !NEXTSTEP
