#import <appkit/appkit.h>
#import <indexing/indexing.h>

@interface MailMessage : Object <IXRecordTranscription>
   {
   id box;
   unsigned int pos;
   unsigned int crc;
   unsigned short len;
   }

-finishReading;
-source:aTranscriber didReadRecord:(unsigned int)aHandle;
-source:aTranscriber willWriteRecord:(unsigned int)aHandle;

-initInBox:(id)nbox at:(unsigned int)npos;
-(BOOL)validate;

-(id)box;
-(unsigned short)len;
-(unsigned int)position;

-(const char *)header:(const char *)header;

-(const char *)messageHeaders;
-(const char *)messageContent;

-(const char *)messageSubject;
-(const char *)messageFrom;
-(const char *)messageTo;
-(const char *)messageDate;
-(const char *)messageId;
-(const char *)messageNextReference;
@end
