#include  <stdio.h>
#include  <libc.h>

#include  "ico.h"

unsigned char *imageMap(FILE *fp, icoHeader *ih)
{
	unsigned char *map, *alp, *pal;
	int	i, j, k, w, x, y, cc, mask;

	ih->palette = (paltype *)malloc(sizeof(paltype) * ih->colors);
	if (ih->palette == NULL)
		return NULL;
	w = ih->x * ih->y;
	if ((map = (unsigned char *)malloc(w + (w >> 3))) == NULL)
		return NULL;
	alp = map + w;
	fseek(fp, ih->offset + 40L, SEEK_SET);
	/* Ignore 40 bytes of Ico-Info Header */
	for (i = 0; i < ih->colors; i++) {
		pal = (unsigned char *)ih->palette[i];
		for (j = 2; j >= 0; j--)
			pal[j] = getc(fp);
			/* Order of colors: Blue, Green, Red */
		(void)getc(fp);
	}
	if (ih->bits == 1) {	/* XOR Data, 8 pixels/byte */
		for (i = 0; i < w; ) {
			cc = getc(fp);
			for (mask = 0x80; mask; mask >>= 1) {
				k = (mask & cc) ? 1 : 0;
				map[i++] = k;
			}
		}
	}else if (ih->bits == 4) {	/* XOR Data, 2 pixels/byte */
		for (i = 0; i < w; ) {
			cc = getc(fp);
			map[i++] = (cc >> 4) & 0x0f;
			map[i++] = cc & 0x0f;
		}
	}else {	/* XOR Data, 1 pixel/byte */
		for (i = 0; i < w; i++)
			map[i] = getc(fp);
	}

	/* AND data is composed with 4-byte clusters */
	k = ((ih->x >> 3) + 3) & ~3;
	i = 0;
	for (y = 0; y < ih->y; y++) {
		for (x = 0; x < ih->x; x += 8)
			alp[i++] = getc(fp);
		for (x >>=3; x < k; x++)
			(void)getc(fp);
	}
	return map;
}

void writeImageMap(FILE *fp, icoHeader *ih, unsigned char *map)
{
	unsigned char *alp, *pal;
	int	i, j, k, w, x, y, cc, mask;

	w = ih->x * ih->y;
	alp = map + w;

	/* 40 bytes of Ico-Info Header */
	put_long(40L, fp);	/* Size of Ico-Info Header */
	put_long(ih->x, fp);
	put_long(ih->y * 2, fp);
	put_short(1, fp);
	put_short(ih->bits, fp);
	put_long(0, fp);
	put_long(0, fp);
	for (i = 0; i < 16; i++)
		fputc(0, fp);

	for (i = 0; i < ih->colors; i++) {
		pal = (unsigned char *)ih->palette[i];
		for (j = 2; j >= 0; j--)
			fputc(pal[j], fp);
			/* Order of colors: Blue, Green, Red */
		fputc(0, fp);
	}
	if (ih->bits == 1) {	/* XOR Data, 8 pixels/byte */
		for (i = 0; i < w; ) {
			cc = 0;
			for (mask = 0x80; mask; mask >>= 1) {
				if (map[i++])
					cc |= mask;
			}
			fputc(cc, fp);
		}
	}else if (ih->bits == 4) {	/* XOR Data, 2 pixels/byte */
		for (i = 0; i < w; ) {
			cc = (map[i++] & 0x0f) << 4;
			cc |= (map[i++] & 0x0f);
			fputc(cc, fp);
		}
	}else {	/* XOR Data, 1 pixel/byte */
		for (i = 0; i < w; i++)
			fputc(map[i], fp);
	}

	/* AND data is composed with 4-byte clusters */
	k = SizeOfANDCluster(ih->x);
	i = 0;
	for (y = 0; y < ih->y; y++) {
		for (x = 0; x < ih->x; x += 8)
			fputc(alp[i++], fp);
		for (x >>=3; x < k; x++)
			fputc(0, fp);
	}
}
