#import "IcoView.h"
#import <AppKit/NSImage.h>
#import <AppKit/NSColor.h>
#import <AppKit/psopsOpenStep.h>

static NSColor	*bgcolor = nil;


@implementation IcoView

+ (void)setBgColor:(NSColor *)col
{
	[bgcolor release];
	bgcolor = col;
	[bgcolor retain];
}

- (void)dealloc
{
	[image release];
	[super dealloc];
}

- (void)setImage:(NSImage *)img
{
	image = img;
	[image retain];
	size = [image size].width;
}

- (void)drawRect:(NSRect)aRect
{
	NSPoint pt;
	NSRect	rect = [self frame];

	if (bgcolor)
		[bgcolor set];
	else
		PSsetgray(0.66667);
	NSRectFill(rect);
	pt.x = (rect.size.width - size) / 2;
	pt.y = (rect.size.height - size) / 2;
	[image compositeToPoint:pt operation:NSCompositeSourceOver];
}

@end
