#import "ElementControl.h"
#import <Foundation/NSBundle.h>
#import <Foundation/NSString.h>
#import <AppKit/NSWindow.h>
#import "IcoView.h"

@implementation ElementControl

- (void)dealloc
{
	[image release];
	[hiddenWindow close];
	[super dealloc];
}

- (id)loadInterface:(id)ctrl
{
	if (imageView == nil) {
		[NSBundle loadNibNamed:@"Element.nib" owner:self];
		hiddenWindow = [imageView window];
		[selectButton setEnabled:NO];
	}
	winctrl = ctrl;
	return [hiddenWindow contentView];
}

- (void)buttonPushed:(id)sender
{
	[winctrl buttonPushed:self];
}

- (void)setImageSize:(int)val
{
	imageSize = val;
	[sizeText setStringValue:
		[NSString stringWithFormat:@"%d x %d", imageSize, imageSize]];
}

- (void)setImage:(NSImage *)img
{
	[selectButton setEnabled:YES];
	[selectButton setState:YES];
	[image release];
	image = img;
	[image retain];
	[imageView setImage:image];
	[imageView display];
}

- (id)image { return image; }

- (int)imageSize { return imageSize; }

- (void)setColors:(int)val
{
	colors = val;
	[colorsText setIntValue: colors];
}

- (int)colors { return colors; }
- (int)state { return [selectButton state]; }

@end
