#import <AppKit/NSView.h>
#import <AppKit/dpsOpenStep.h>
#import <AppKit/NSDPSContext.h>

// Maximum number of tiles in the playing area...

#define NUMTILESX 8      
#define NUMTILESY 20

#define NUMTILETYPES 2   // Number of different tile types.

#define TILEHEIGHT	18.0  // Tile size, in pixels
#define TILEWIDTH	28.0				
#define INTERTILE	2.0

#define GAMEWIDTH  ((TILEWIDTH+INTERTILE) * NUMTILESX)  // Size of the field.
#define GAMEHEIGHT ((TILEHEIGHT+INTERTILE) * NUMTILESY)

@interface BreakView:NSView  {
   
   int numTilesLeft, score, level, lives, highScore;

   BOOL gameRunning, demoMode, soundEnabled;

   NSTimer *timer;

   NSTimeInterval lastFrameTime;

   // The various pieces that know how to draw themselves on the field.

   id tile[NUMTILETYPES];

   // The actual array of tiles on the field. tiles[x][y] is the id of the
   // tile that is at location x * TILEWIDTH, y * TILEHEIGHT.

   short tiles[NUMTILESX][NUMTILESY];
   id ball, paddle, backGround;

   // The following six are outlets set when the nib file is being
   // read in.
   
   // Views that display various info (these can be nil, in which case the
   // corresponding info will just go to the bit bucket). 
   
   id scoreView;
   id livesView;
   id levelView;
   id hscoreView;
   id statusView;

   id wallSound;
   id tileSound;
   id paddleSound;
   id missSound;
   
   // Other ball & paddle params
   float ballX, ballY, paddleX, paddleY, ballXVel, ballYVel, leftMargin;

   NSSize ballSize, paddleSize, tileSize;

   // These variables store the of the ball. Killer ball goes through tiles
   // without bouncing; nice ball bounces from the top wall towards the paddle. 
   BOOL killerBall, niceBall;

   // Number of revolutions left if the ball is rotating. If zero or
   // less, than the ball is not rotating...
   float revolutionsLeft;
   float revolutionSpeed; // Radians per millisecond if rotating

}

// The following methods can be called by Interface Builder objects &
// during creation/destruction of instances of BreakView.

- (void)gotoFirstLevel:sender;	// Essentially a "new game"
- (void)gotoNextLevel:sender;	// Doesn't have to be explicitly called by user
- (void)setDemoMode:sender;	// Connect to switch with binary state
- (void)setSoundMode:sender;	// Connect to switch with binary state	 
- (void)go:sender;              // mouseDown: on the view does the same thing
- (void)stop:(id)sender;

- (void)changeBackground:sender;
- (void)revertBackground:sender;

// Methods to get back status of game.

- (int)score;
- (int)level;
- (int)lives;

// The following methods are internal and probably should not be called
// by others.

- (void)setBackgroundFile:(NSString *)fileName andRemember:(BOOL)remember;
- (void)setHighScore:(int)hScore;
- (void)getHighScore;
- (void)resizePieces;
- (void)resetBallAndPaddle;
- (void)directBallAt:(NSPoint)dest; 
- (void)drawRect:(NSRect)rects;
- (void)drawBackground:(NSRect)rect;
- (void)eraseBall;
- (void)erasePaddle;
- (void)showBall;
- (void)showPaddle;
- (void)incrementGameScore:(int)scoreIncrement;
- (BOOL)hitTileAt:(int)x :(int)y;
- (void)step:(NSTimer *)timer;
- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent;
- (void)playSound:sound atXLoc:(float)xLoc;

@end
