/*
 BreakApp.m, controller class for BreakApp.
 Author: Ali Ozer
 Written for 1.0 July 89.
 Modified for 2.0 Sept 90; separated the panels into their own .nib files.
 Modified for 3.0 March 92
 Modified for 4.0 Jan 96
 Modified for Rhapsody June 97

 This class manages the windows & such for the BreakApp application.

 Copyright (c) 1988-1997 by Apple Computer, Inc., all rights reserved.

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>
#import "BreakApp.h"
#import "BreakView.h"

@implementation BreakApp

// applicationDidFinishLaunching: is called as the first thing in the run loop of the 
// application. At this point, everything is created, but we haven't entered
// the event loop yet. applicationDidFinishLaunching: initializes a few things and
// calls the gotoFirstLevel: method of the BreakView instance to get
// started on a new game.

- (void)applicationDidFinishLaunching:(NSNotification *)notification {
    NSRect gameWindowFrame, controlWindowFrame;

    // Put the control window right next to the game window (game window is
    // set to come up "right" automatically on different sized screens).
    gameWindowFrame = [gameWindow frame];
    controlWindowFrame = [controlWindow frame];
    (&controlWindowFrame)->origin.y = NSMaxY(gameWindowFrame) - NSHeight(controlWindowFrame);
    (&controlWindowFrame)->origin.x = NSMinX(gameWindowFrame) - NSWidth(controlWindowFrame) - 2.0;
    [controlWindow setFrameOrigin:NSMakePoint(NSMinX(controlWindowFrame), NSMinY(controlWindowFrame))];

    [game gotoFirstLevel:self];

    [controlWindow orderFront:self];
    [gameWindow makeKeyAndOrderFront:self];
}

// applicationDidHide: is called when the application is hidden. It doesn't
// make sense to run the game while the application is running, also,
// in case the boss walks by you want to be able to hit just Command-h and
// have the game hide and pause at the same time. This way the boss won't
// ask where "ping-ping" noises are coming from and you will not have lost
// a high-score game.

- (void)applicationDidHide:(NSNotification *)notification {
   [game stop:self];
}

// We do pretty much the same if the user miniaturizes or closes the game window.

- (void)windowDidMiniaturize:(NSNotification *)notification {
   NSWindow *theWindow = [notification object];
   if (theWindow == gameWindow) [game stop:self];
}

- (void)windowWillClose:(NSNotification *)notification {
   NSWindow *theWindow = [notification object];
   if (theWindow == gameWindow) [game stop:self];
}

- (NSRect)windowWillUseStandardFrame:(NSWindow *)window defaultFrame:(NSRect)newFrame {
    NSRect currentFrame = [window frame];	// Get the current frame
    NSRect rect;
    rect.size = [[gameWindow class] frameRectForContentRect:NSMakeRect(0, 0, GAMEWIDTH, GAMEHEIGHT) styleMask:[gameWindow styleMask]].size;	// Get the good size
    rect.origin.y = NSMaxY(currentFrame) - rect.size.height;
    rect.origin.x = currentFrame.origin.x;
    return rect;
}

// printGame: allows us to print the game window. We could've just connected
// the "Print..." menu item to the window's print; however, we
// wanted to be able to change the title to reflect the status.

- (void)printGame:(id)sender {
    NSString *savedTitle = [[gameWindow title] copy];
    NSString *statusString;

    statusString = [NSString stringWithFormat:NSLocalizedString(@"Score: %d  Level: %d", "Score and level to be shown when the game window is printed"), [game score], [game level]];
    [gameWindow setTitle:statusString];
    [gameWindow print:sender];
    [gameWindow setTitle:savedTitle];
    [savedTitle release];
}


// Method to load the .nib file for the info panel.

- (void)showInfo:(id)sender {
    if (!infoPanel) {
        if (![NSBundle loadNibNamed:@"Info" owner:self])  {
            NSLog(@"Failed to load Info.nib");
            NSBeep();
            return;
        }
        [infoPanel center];
    }
    [infoPanel makeKeyAndOrderFront:nil];
}
@end
