// Copyright 1998 Omni Development, Inc.  All rights reserved.

#import "OLIndexFolderDragging.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>

#import "OLIndexedFolder.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniLibrarian/OLIndexFolderDragging.m,v 1.4 1998/03/14 05:04:45 andrew Exp $")

@implementation OLIndexFolderDragging

static NSMutableArray *acceptedPasteboardTypes;
static NSString *OLIndexFolderType = @"OmniLibrarian Indexed Folder 1.0";

+ (void)initialize;
{
    acceptedPasteboardTypes = [[NSMutableArray alloc] init];
    [acceptedPasteboardTypes addObject:OLIndexFolderType];
    [acceptedPasteboardTypes addObject:NSFilenamesPboardType];
}

+ (NSString *)indexFolderType;
{
    return OLIndexFolderType;
}

/* dragging in */
- (NSArray *)acceptedPasteboardTypes;
{
    return acceptedPasteboardTypes;
}

- (id)entryFromPropertyList:propertyList ofType:(NSString *)type;
{
    OLIndexedFolder *result;

    if ([type isEqualToString:OLIndexFolderType]) {
        NSDictionary *info = propertyList;

	result = [[OLIndexedFolder alloc] initWithInfoDictionary:info];
    } else {
        NSArray *array = propertyList;

        result = [[OLIndexedFolder alloc] initWithIndexFilename:nil forFolder:[array objectAtIndex:0] label:nil lastUpdate:nil];
    }
    return [result autorelease];
}

/* dragging out */
- (NSImage *)dragImageForEntry:(id)anEntry;
{
    OLIndexedFolder *folder = anEntry;
    
    return [[NSWorkspace sharedWorkspace] iconForFile:[folder folder]];
}

- (void)declareTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
{
    [pasteboardHelper declareTypes:acceptedPasteboardTypes owner:anEntry];
}

- (void)startDragOnEntry:anEntry fromView:(NSView *)aView image:(NSImage *)anImage atPoint:(NSPoint)location event:(NSEvent *)event pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
{
    NSPoint                     zero;

    zero = NSMakePoint(0.0, 0.0);
    [self declareTypesForEntry:anEntry pasteboardHelper:pasteboardHelper];
    [[OADragController sharedDragController] startDragFromView:aView image:anImage atPoint:location offset:zero event:event slideBack:NO pasteboardHelper:pasteboardHelper delegate:self];
}

@end
