/*
        Copyright (c) 1999 Turbocat's Development. http://www.turbocat.de/ info@turbocat.de
*/
#import <EOAccess/EOAccess.h>
#import <PostgreSQL/libpq-fe.h>

@class PostgreSQLAdaptor;
@class PostgreSQLChannel;

#define ColumnNameKey @"name"
#define ColumnTypeKey @"type"

@interface PostgreSQLContext:EOAdaptorContext
{
    NSMutableDictionary *tableNameToInfoMap;
//    NSMutableSet *dirtyTables;
    BOOL didAutoBegin;
	// dave@turbocat.de for postgres
  	//PGconn* conn;
  	//PGresult* res;
}

- initWithPostgreSQLAdaptor:(PostgreSQLAdaptor *)adaptor;
- (void)dealloc;
- (EOAdaptorChannel *)createAdaptorChannel;
- (void)beginTransaction;
- (void)commitTransaction;
- (void)rollbackTransaction;
- (BOOL)canNestTransactions;


- (NSMutableData *)dataForTable:(NSString *)tableName;
- (NSArray *)columnInfosForTable:(NSString *)tableName;
//- (NSDictionary *)columnIndexMapForTable:(NSString *)tableName;
- (void)channel:(PostgreSQLChannel *)channel didDirtyTable:(NSString *)tableName;

- (BOOL)autoBeginTransaction;
- (BOOL)autoCommitTransaction;
// GERALD BEGIN
- (BOOL)autoCommitTransactionCanceled;
// GERALD ENDE

- (NSString *)path;

@end
