/*
        Copyright (c) 1999 Turbocat's Development. http://www.turbocat.de/ info@turbocat.de
*/
#import "PostgreSQLAdaptor.h"
#import "PostgreSQLChannel.h"

@class EOAttribute;

@interface PostgreSQLColumn:NSObject
{
    EOAttribute *attribute;
    int bindingIndex;
}

+ (Class)columnClassForAttribute:(EOAttribute *)attr;
+ columnForAttribute:(EOAttribute *)attr;

- initWithAttribute:(EOAttribute*)attr;
- (void)bindAtIndex:(int)index;
- (int)bindingIndex;
- (id)newValueForBytes:(void *)bytes length:(int)length;

@end

@interface PostgreSQLNumberColumn:PostgreSQLColumn
{
    BOOL useIntValue;
}

- (id)newValueForBytes:(void *)bytes length:(int)length;

@end

@interface PostgreSQLStringColumn:PostgreSQLColumn
{
    NSStringEncoding encoding;
}

- initWithAttribute:(EOAttribute *)attr;
- (id)newValueForBytes:(void *)bytes length:(int)length;

@end

@interface PostgreSQLDataColumn:PostgreSQLColumn

- (id)newValueForBytes:(void *)bytes length:(int)length;

@end

@interface PostgreSQLDateColumn:PostgreSQLColumn
{
}

- (id)newValueForBytes:(void *)bytes length:(int)length;

@end
