/*
        Copyright (c) 1999 Turbocat's Development. http://www.turbocat.de/ info@turbocat.de
*/
// Fri Dec  5 17:36:48 MET 1997 	dave@turbocat.de


#import <EOAccess/EOAccess.h>
#import <PostgreSQL/libpq-fe.h>

// GERALD
//#import <EOAccess/EOAdaptor.h>
// GERALD ENDE

@class PostgreSQLContext;

typedef enum {String, Int, Float, Date, Data} PostgreSQLDataType;

@interface PostgreSQLChannel:EOAdaptorChannel
{
	// dave@turbocat.de for postgres
    NSString* _errorMessage;
  	PGconn* conn;
    PGconn* connBlob;
    PGresult* res;

    EOEntity *selectedEntity;
    NSMutableArray *columnAttributes;
    NSArray *selectedAttributes;
    NSMutableArray *columns;
    NSMutableArray *resultSet;
    NSEnumerator *resultEnumerator;
    NSString *rowSeparator;
    NSString *columnSeparator;
    unsigned affectedRows; 			// PQcmdTuples tells us this
    unsigned fetchedRows; 			// the number of rows we have done in this fetch
    BOOL	_fetchWasCanceled;
    struct
    {
        unsigned isOpen:1;
        unsigned isFetchInProgress:1;
        unsigned returnOIDs:1;		// if this is YES, fetchRowWithZone returns the OID NOT the DATA
        unsigned _RESERVED:30;
    } _flags;
}

- (PGconn*)conn;
- initWithPostgreSQLContext:(PostgreSQLContext *)context;
- (void)dealloc;
- (void)openChannel;
- (void)closeChannel;
- (BOOL)isOpen;
- (void)insertRow:(NSDictionary *)row forEntity:(EOEntity *)entity;
- (unsigned)updateValues:(NSDictionary *)values
    inRowsDescribedByQualifier:(EOQualifier *)qualifier entity:(EOEntity *)entity;
- (unsigned)deleteRowsDescribedByQualifier:(EOQualifier *)qualifier entity:(EOEntity *)entity;
- (void)selectAttributes:(NSArray *)attributes fetchSpecification:(EOFetchSpecification *)spec lock:(BOOL)lockBool entity:(EOEntity *)entity;
- (void)evaluateExpression:(EOSQLExpression *)expression;
- (BOOL)isFetchInProgress;
- (NSArray *)describeResults;
- (NSMutableDictionary *)fetchRowWithZone:(NSZone *)zone;
- (void)cancelFetch;
- (NSDictionary *)primaryKeyForNewRowWithEntity:(EOEntity *)entity;

@end
