
#import "TextFieldStringFinder.h"
#import "StringStringFinder.h"

@implementation NSTextField(StringFinder)

- (BOOL)findString:(NSString *)findString direction:(int)direction wrap:(BOOL)wrap
{
    NSString *string;
    NSRange range;

    int mask = NSCaseInsensitiveSearch;
    if (!direction)
        mask = mask | NSBackwardsSearch;
    string = [self stringValue];
    // note, I believe that "insertion point" and "selectedRange" are the same. It's just
    // that an insertion point represented as a range can have a 0 length but still have a valid
    // location
    range = [string findString:findString selectedRange:[[self currentEditor] selectedRange] options:mask wrap:wrap];
    
    if (range.length) {
        [[self currentEditor] setSelectedRange:range];
        [[self currentEditor] scrollRangeToVisible:range];
        return YES;
    }
    return NO;
}

- (NSString *)selectedString
{
    NSRange range;
    NSString *string;

    range = [[self currentEditor] selectedRange];
    // does this just work if range length is 0
    string = [[self stringValue] substringWithRange: range];
    return string;
}

@end
