/* Logger.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "Logger.h"

@implementation Logger

- (id)init
{
    self = [super init];
    return self;
}

- (void)dealloc
{
    [super dealloc];
}

- (void)awakeFromNib
{
}

- (void)log:(NSString *)string
{
}

// Class/Factory method
// It can be used by a client without an outlet to the actual log instance:
//		[Logger log: myString]
// It can be used to encapsulate logging using notifications 
// 
+ (void)log:(NSString *)string
{
}

// Access to logger features: target/action style messages for
// Controls or programmatic access

- (void)show:(id)sender
{
    [panel orderFront:self];
}

- (void)clear:(id)sender
{
}

- (void)save:(id)sender
{
    NSSavePanel *p = [NSSavePanel savePanel];
    if ([p runModal] == NSOKButton)
    {
		NSString *file = [p filename];
		// save the file
	}
}

- (void)load:(id)sender
{
    NSOpenPanel *p = [NSOpenPanel openPanel];
    if ([p runModal] == NSOKButton)
    {
		NSString *file = [p filename];
		// load the file
	}
}

- (void)changeIsEnabled:(id)sender
{
}

- (void)changeIsTimeStamping:(id)sender
{
}

- (void)changeIsAutoScrolling:(id)sender
{
}

- (void)setIsEnabled:(BOOL)state
{
	isEnabled = state;
}

- (BOOL)isEnabled
{
    return isEnabled;
}

- (void)setIsTimeStamping:(BOOL)state
{
	isTimeStamping = state;
}

- (BOOL)isTimeStamping
{
    return isTimeStamping;
}

// Helper method: log a timestamp string
- (void)timeStamp
{
}

- (void)setIsAutoScrolling:(BOOL)state
{
	isAutoScrolling = state;
}

- (BOOL)isAutoScrolling
{
    return isAutoScrolling;
}

- (NSString *)title
{
    return [panel title];
}

- (void)setTitle:(NSString *)string
{
    [panel setTitle:string];
}

@end
