/* DocController.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <AppKit/AppKit.h>

@interface DocController : NSObject
{
    id window;
    id dataSource;
    BOOL new;
}

// Factory method for OpenPanel selection; can return nil if user cancels
+ (DocController *)newFromOpen;

- (id)initFromFile:(NSString *)file;	// designated initializer
- (id)init;
- (void)dealloc;

- (NSString *)title;
- (void)setTitle:(NSString *)newTitle;
- (BOOL)isDocumentEdited;
- (void)setDocumentEdited:(BOOL)isEdited;
- (BOOL)isNew;
- (id)dataSource;
- (void)setDataSource:(id)newDataSource;

// Window delegation/notification
- (BOOL)windowShouldClose:(id)sender;

// target/action
- (void)modify:(id)sender;
- (void)show:(id)sender;
- (void)save:(id)sender;
- (void)saveAs:(id)sender;
- (void)revert:(id)sender;
- (void)close:(id)sender;

- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;

@end
