/* ExpenseDataSource.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "ExpenseDataSource.h"
#import "Expense.h"

@implementation ExpenseDataSource

// private helper method: update the UI when the data array has changed
- (void)_update
{
    [tableView noteNumberOfRowsChanged];
    [tableView reloadData];
}

// private helper method: generate an array of test expense objects
- (void)_generateTestData
{
	int i;
	for (i = 0; i < 10; i++)
	{
		id expense = [[Expense alloc] init];
		[expense setCategory:[NSString stringWithFormat:@"Cat%d", i]];
		[expense setAmount:[NSNumber numberWithInt:(10 - i)]];
		[expense setDate: 
			[NSCalendarDate dateWithTimeIntervalSinceNow: 60*60*24*i]];
		[expense setIsBillable: i % 2];
		[array addObject:expense];
		[expense release];
	}
}

- (id)init
{
    [super init];
    [self setArray: [NSMutableArray array]];
    [self _generateTestData];
    return self;
}

- (void)dealloc
{
    [array release];
    [super dealloc];
}

- (void)awakeFromNib
{
}

- (void)setArray:(NSMutableArray *)theArray
{
    [theArray retain];
    [array release];
    array = theArray;
    [self _update];
}

- (NSMutableArray *)array
{
    return array;
}

- (SEL)accessorFromIdentifier:(NSString *)identifier
{
	return NSSelectorFromString(identifier);
}

- (SEL)setAccessorFromIdentifier:(NSString *)identifier
{
	NSString *string = [@"set" stringByAppendingString:
                                [[identifier capitalizedString]
                                        stringByAppendingString:@":"]];
	return NSSelectorFromString(string);
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView
{
	return [array count];
}

- (id)tableView:(NSTableView *)tv objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
}

- (void)tableView:(NSTableView *)tv setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
}

@end
