#import "Backup.h"
#import "AppController.h"

@implementation Backup

- (void)setTimeText:(BOOL)isEnabled
{
        NSString *str;
        int n = [slider intValue];
        if (n == 1) str = [NSString stringWithFormat:@"%d minute", n];
        else        str = [NSString stringWithFormat:@"%d minutes", n];
        [text setStringValue: str];
}

- (void)awakeFromNib
{
    BOOL doAutosave;
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

    doAutosave = [defaults boolForKey: @"autoSave"];
    [check setState: doAutosave];
    [slider setIntValue: [defaults integerForKey: @"autoSaveInterval"]];
    [self setTimeText: doAutosave];
    [super awakeFromNib];
}

- (void)change:(id)sender
{
    BOOL doAutosave;
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    int mins;

    doAutosave = [check state];
    if (sender == check) mins = [slider intValue];
    else                 mins = [sender intValue];
    if (sender != slider) [slider setIntValue: mins];

    [defaults setBool: doAutosave  forKey: @"autoSave"];
    [defaults setInteger: mins forKey: @"autoSaveInterval"];
    [self setTimeText:doAutosave];
    [[NSApp delegate] startAutoSaving];
}

@end
