

#import "TextViewStringFinder.h"
#import "StringStringFinder.h"

@implementation NSTextView(StringFinder)

- (BOOL)findString:(NSString *)findString direction:(int)direction wrap:(BOOL)wrap
{
    NSString *string;
    NSRange range;
    
    int mask = NSCaseInsensitiveSearch;
    if (!direction)
        mask = mask | NSBackwardsSearch;
    string = [self string];
    // note, I believe that "insertion point" and "selectedRange" are the same. It's just
    // that an insertion point represented as a range can have a 0 length but still have a valid
    // location
    range = [string findString:findString
                    selectedRange:[self selectedRange]
                    options:mask
                    wrap:wrap];
    if (range.length) {
        [self setSelectedRange:range];
        [self scrollRangeToVisible:range];
        return YES;
    }
    return NO;
}

- (NSString *)selectedString
{
    NSRange range;
    NSString *string;

    range = [self selectedRange];
    // does this just work if range length is 0
    string = [[self string] substringWithRange: range];
    return string;
}

@end
