

#import "TableViewStringFinder.h"

@implementation NSTableView(StringFinder)

// Construct a string representation for a row by concatenating each
// column value together separated by a tab

- (NSString *)descriptionForRow:(int)row
{
    id dataSource = [self dataSource];
    NSArray *tableColumns = [self tableColumns];
    NSMutableArray *contents = [NSMutableArray array];
    int ncols = [self numberOfColumns];
    int col;

    for (col = 0; col < ncols; col++)
    {
        NSTableColumn *tableColumn = [tableColumns objectAtIndex:col];
        id object = [dataSource tableView:self
                objectValueForTableColumn:tableColumn
                                      row:row];
        if (object)
        {
            NSCell *cell = [tableColumn dataCell];
            NSString *string;
            [cell setObjectValue:object];
            string = [cell stringValue];
            // If we get no response, we can't search this cell
            if (!string) string = @"";
            [contents addObject:string];
        }
    }

    return [contents componentsJoinedByString:@"\t"];
}


// Search each row starting from the selected one

- (BOOL)findString:(NSString *)findString direction:(int)direction wrap:(BOOL)wrap
{
    int nrows = [self numberOfRows];
    int row = 0, rowcount;
    int incr;
    int mask = NSCaseInsensitiveSearch;
    BOOL found = NO;
    NSString *string;
    NSRange range;

    // Need to start from selected row and wrap around (assuming wrap is
    // selected)
    if (direction)
    {
        incr = 1;
    }
    else
    {
        incr = -1;
        mask |= NSBackwardsSearch;
    }

    row = [self selectedRow];
    if (row < 0)
    {
        row = (0 - incr + nrows) % nrows;
    }
    rowcount = 0;

    // We search rows in the appropriate order, starting in the
    // appropriate place, but columns only in sequential order.
    // This means you can't search across columns.
    while (!found && (rowcount++ < nrows))
    {
        row = (row + incr + nrows) % nrows;

        string = [self descriptionForRow:row];
        range = [string rangeOfString:findString options:mask];

        if (range.length)
        {
            found = YES;
            [self selectRow:row byExtendingSelection:NO];
            [self scrollRowToVisible:row];
            break;
        }
   }
   
    return found;
}

- (NSString *)selectedString
{
    NSString *string;
    int row = [self selectedRow];

    if (row >= 0)
    {
        string = [self descriptionForRow:row];
    }
    else string = @"";
    return string;
}

@end
