

#import "SortableTableRow.h"
#import <Foundation/NSDictionary.h>
#import <Foundation/NSString.h>

@implementation SortableTableRow

- (id)initWithRow:(unsigned)row;
{
    self = [super init];
    originalRow = row;
    return self;
}

- (void)dealloc
{
    [sortKey release];
    [super dealloc];
}

- (void)setSortKey:(id)theCell
{
    [theCell retain];
    [sortKey release];
    sortKey = theCell;
}

- (id)sortKey
{
    return sortKey;
}

- (unsigned)originalRow
{
    return originalRow;
}

// If a sort column has been set, use that, otherwise original order
- (NSComparisonResult)compare:(id)otherRow
{
    id otherKey = [otherRow sortKey];
    if (sortKey && otherKey)
        return [sortKey compare:otherKey];
    else
    {
        unsigned row2 = [otherRow originalRow];
        if (originalRow > row2) return NSOrderedAscending;
        else if (originalRow < row2) return NSOrderedDescending;
        return NSOrderedSame;
    }
}

- (NSString *)description
{
    return [NSString stringWithFormat:@"%@ sort key: %@ old row: %d",
        [super description], sortKey, originalRow];
}
@end
