#import "TimerController.h"

@implementation TimerController

- (void)awakeFromNib
{
    // if we were instantiated in a nib, well, we ought to become key then
    [[timerText window] makeKeyAndOrderFront: nil];
    // [self resetTimer];
}

// get the time, compute time interval and set GUI
- (void)updateTimer:(NSTimer *)aTimer
{
    NSString *timeStr;
    NSTimeInterval interval;
    unsigned int i, m, s, c;

    interval = [[NSCalendarDate date] timeIntervalSinceDate: startTime];
    i = interval; // assume it will fit in an unsigned int!
    i = i % (60*60);
    m = i / 60;
    s = i % 60;
    c = (unsigned int)(interval * 100.0) % 100;

    timeStr = [NSString stringWithFormat: @"%d:%02d:%02d", m, s, c];
    [timerText setStringValue: timeStr];
    [timeBar setIntValue:s];
}

- (void)resetTimer
{
    [startTime release];
    startTime = [[NSCalendarDate date] retain];
    [stopText setStringValue: @""];
    [startText setObjectValue: startTime];
    [timerText setStringValue: @"0:00:00"];
    [timeBar setIntValue:0];
}

- (void)changeState:(id)sender
{
    if ([sender state])
    {
        // start the timer
        [self resetTimer];
        // Let's try 1/100 th of a second for fun ...
        timer = [NSTimer scheduledTimerWithTimeInterval:0.01
                         target:self
                         selector:@selector(updateTimer:)
                         userInfo:nil
                         repeats:YES];
    }
    else
    {
        // stop the timer - invalidating it means it will disappear ...
        [timer invalidate];
        [stopText setObjectValue:[NSCalendarDate date]];
    }
}

@end
