/* PrefController.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "PrefController.h"

@implementation PrefController

/*
 *  sortByColumn: 		Category|Date|Amount|None
 *  showInspector: 		YES|NO
 *  defaultNewCategory: New|"Any string"
 *  autoSave: 			YES|NO
 *  autoSaveInterval: 	10-120 seconds
 */

+ (void)initialize
{
    // Just in case a subclass doesn't implement initialize or sends us this
    // explicitly
    if ([self class] == [PrefController class])
    {
        // Register default preferences
		// In 4.0, we have to do this explcitly. In 4.1, NSApplication
		// will do this automagically.
		// Read 'em from the dictionary file "Defaults.plist" in the main bundle. 
        NSBundle *mainBundle = [NSBundle mainBundle];
        NSString *path = [mainBundle pathForResource:@"Defaults" ofType:@"plist"];
        NSDictionary *dictionary = [NSDictionary dictionaryWithContentsOfFile:path];

        [[NSUserDefaults standardUserDefaults] registerDefaults:dictionary];
    }
}

- (void)show:(id)sender
{
    if (!panel)
    {
        NSButtonCell *item;
        if (![NSBundle loadNibNamed:@"Preferences" owner:self])
        {
            NSLog(@"Unable to load nib '%@'", @"Preferences");
            return;
        }
        // Load the first preference view
        item = [popup selectedItem];
        [[item target] performSelector:[item action] withObject:self];
    }
    [panel makeKeyAndOrderFront:self];
}

- (void)switchView:(NSView *)view
{
    [(NSBox *)box setContentView:view];	// Cast to avoid compiler warning

    // display it
    [box setNeedsDisplay: YES];
}

@end
