/* AppController.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "AppController.h"
#import "AboutPanel.h"
#import "DocController.h"

@implementation AppController

- (id)init
{
    self = [super init];
    documents = [[NSMutableArray alloc] init];
    return self;
}

- (void)dealloc
{
    [aboutPanel release];
    [documents release];
    [super dealloc];
}

- (void)registerDocument:(id)doc
{
    [documents addObject:doc];
}

- (void)unregisterDocument:(id)doc
{
    [documents removeObject:doc];
}

- (void)newDocument:(id)sender
{
    // create and register a new doc
    id	doc = [[DocController alloc] init];
    [self registerDocument:doc];
    [doc release];
}

- (void)showAboutPanel:(id)sender
{
    if (!aboutPanel)
    {
        // first time through
	Class class;

	// find the bundle in the mainBundle
	NSBundle *bundle = [NSBundle bundleWithPath:[[NSBundle mainBundle]
				pathForResource:@"AboutPanel" ofType:@"bundle"]];  

        // alloc/init AboutPanel instance
        if (class = [bundle principalClass])
        {
            aboutPanel = [[class alloc] init];
        }
        else
        {
            NSLog(@"AppController: problem loading AboutPanel");
            return;
        }
    }
    // show it
    [aboutPanel show: nil];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    // Ensure there is at least one doc window open to start with
    if ([documents count] == 0)
    {
        [self newDocument:self];
    }
}

- (BOOL)applicationShouldTerminate:(id)sender
{
    NSEnumerator *enumerator = [documents objectEnumerator];
    NSMutableArray *modified = [NSMutableArray array];
    id doc;

    while (doc = [enumerator nextObject])
    {
        if ([doc isDocumentEdited]) [modified addObject:doc];
    }

    if ([modified count] > 0)
    {
        int ret;
        ret = NSRunAlertPanel(@"Quit",
                              @"There are modified documents",
                              @"Review Unsaved",
                              @"Quit Anyway",
                              @"Cancel"
                              );
        switch (ret)
        {
            case NSAlertDefaultReturn:
                enumerator = [modified objectEnumerator];
                while (doc = [enumerator nextObject])
                {
                    [doc close:self];
                    // if the doc was not unregistered, we should cancel
                    if ([documents indexOfObject:doc] != NSNotFound)
                    {
                        return NO;
                    }
                }
                break;
            case NSAlertAlternateReturn:
                break;
            case NSAlertOtherReturn:
                return NO;
        }
    }

    return YES;
}

@end
