/* AppController.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "AppController.h"

@implementation AppController

- (id)init
{
    self = [super init];
    string = [[NSMutableString alloc] initWithString:@"Hello World"];
    return self;
}

- (void)dealloc
{
    [string release];
    [super dealloc];
}

- (void)awakeFromNib
{
    [self stringChanged:stringField];
    [[stringField window] makeKeyAndOrderFront:nil];
    [stringField selectText:nil];
}

- (void)capitalize:(id)sender
{
    [string setString:[string capitalizedString]];
    [stringField setObjectValue:string];
    [stringField selectText:nil];
}

- (void)lower:(id)sender
{
    [string setString:[string lowercaseString]];
    [stringField setObjectValue:string];
    [stringField selectText:nil];
}

- (void)stringChanged:(id)sender
{
    [string setString:[sender stringValue]];
    [lengthField setIntValue:[string length]];
    [stringField selectText:nil];
}

- (void)upper:(id)sender
{
    [string setString:[string uppercaseString]];
    [stringField setObjectValue:string];
    [stringField selectText:nil];

}

@end
