/* StockHolding.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "StockHolding.h"
#import <Foundation/Foundation.h>

@implementation StockHolding

- (id)init
{
    [super init];
    [self setTickerID:@""];
    return self;
}

- (void)dealloc
{
    [tickerID release];
    [super dealloc];
}

- (id)initWithCoder:(NSCoder *)coder
{
    [super initWithCoder:coder];
    [self setTickerID:[coder decodeObject]];
    [coder decodeValueOfObjCType:@encode(double) at:&stockPrice];
    [coder decodeValueOfObjCType:@encode(int) at:&shares];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
    [super encodeWithCoder:coder];
    [coder encodeObject:[self tickerID]];
    [coder encodeValueOfObjCType:@encode(double) at:&stockPrice];
    [coder encodeValueOfObjCType:@encode(int) at:&shares];
}

- (void)setTickerID:(NSString *)anID
{
    [tickerID autorelease];
    tickerID = [anID copy];
}

- (NSString *)tickerID
{
    return tickerID;
}

- (void)setStockPrice:(double)aPrice
{
    stockPrice = aPrice;
}

- (double)stockPrice
{
    return stockPrice;
}

- (void)setShares:(int)aNumber
{
    shares = aNumber;
}

- (int)shares
{
    return shares;
}


- (double)value
{
    double theValue;

    theValue = [self stockPrice] * [self shares];
    return theValue;
}

@end
