/* PortfolioController.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "PortfolioController.h"

#import "Portfolio.h"
#import "StockHolding.h"

@implementation PortfolioController

- (id)init
{
    Portfolio *newPortfolio;
    
    newPortfolio = [[Portfolio alloc] init];
    [self initWithPortfolio:newPortfolio];
    return self;
}

- (id)initWithPortfolio:(Portfolio *)aPortfolio
{
    [super init];
    [self setPortfolio:aPortfolio];
    return self;
}

- (void)dealloc
{
    [portfolio release];
    [super dealloc];
}


- (void)setPortfolio:(Portfolio *)aPortfolio
{
    [portfolio autorelease];
    portfolio = [aPortfolio retain];
    if ([portfolio numberOfAssets] > 0) {
        displayedIndex = 0;			// select first asset if there are any
    } else {
        displayedIndex = -1;			// -1 means no selection
    }
}

- (Portfolio *)portfolio
{
    return portfolio;
}


- (void)deleteStock:(id)sender
{
    int numberOfStocks;
    
    if (displayedIndex >= 0) {				// index starts at 0
        [portfolio removeAssetAtIndex:displayedIndex];
        numberOfStocks = [portfolio numberOfAssets];
        if (displayedIndex >= numberOfStocks) {		// displaying a stock that doesn't exist
            displayedIndex = numberOfStocks - 1;	// display the last stock instead
        }
    }
    [self fillFields];
}

- (void)newStock:(id)sender
{
    StockHolding *newStockHolding;
    int numberOfStocks;

    newStockHolding = [[StockHolding alloc] init];	// new StockHolding to add to portfolio
    [self saveChangesToSelection];		
    [portfolio addAsset:newStockHolding];	// adds new StockHolding to the end of list
    numberOfStocks = [portfolio numberOfAssets];
    displayedIndex = numberOfStocks - 1;	// display last StockHolding; indexing starts at 0
    [newStockHolding autorelease];		// PortfolioController shouldn't retain the new
                                                // StockHolding
    [self fillFields];				// update the user interface
}

- (void)nextStock:(id)sender
{
    if (displayedIndex < ([portfolio numberOfAssets] - 1)) {	// index starts at 0
        [self saveChangesToSelection];
        displayedIndex = displayedIndex + 1;
        [self fillFields];
    }
}

- (void)previousStock:(id)sender
{
    if (displayedIndex > 0) {
        [self saveChangesToSelection];
        displayedIndex = displayedIndex - 1;
        [self fillFields];
    }
}

- (void)open:(id)sender
{
    NSOpenPanel *openPanel;
    NSString *filename;
    Portfolio *newPortfolio;

    openPanel = [NSOpenPanel openPanel];
    if ([openPanel runModal] == NSOKButton) {
        filename = [openPanel filename];
        newPortfolio = [NSUnarchiver unarchiveObjectWithFile:filename];
        [self setPortfolio:newPortfolio];
        [self fillFields];
    }
}

- (void)save:(id)sender
{
    NSSavePanel *savePanel;
    NSString *filename;

    savePanel = [NSSavePanel savePanel];
    if ([savePanel runModalForDirectory:@"" file:@""] == NSOKButton) {
        filename = [savePanel filename];
        [NSArchiver archiveRootObject:[self portfolio] toFile:filename];
    }
}

- (void)saveChangesToSelection
{
    StockHolding *theStockHolding;

    if (displayedIndex != -1) {		// make sure there's a selection
        theStockHolding = (StockHolding *)[portfolio assetAtIndex:displayedIndex];
        
        [theStockHolding setName:[nameField objectValue]];
        [theStockHolding setStockPrice:[priceField doubleValue]];
        [theStockHolding setShares:[sharesField intValue]];
        [theStockHolding setTickerID:[tickerField objectValue]];    }
}

- (void)fillFields
{
    StockHolding *theStockHolding;
    NSString *boxTitle;
    int totalStocks;

    totalStocks = [portfolio numberOfAssets];
    if (totalStocks > 0) {
        theStockHolding = (StockHolding *)[portfolio assetAtIndex:displayedIndex];

        boxTitle = [NSString stringWithFormat:@"Stock %i/%i", displayedIndex + 1, totalStocks];
        [stockDisplayBox setTitle:boxTitle];

        [nameField setStringValue:[theStockHolding name]];
        [assetValueField setDoubleValue:[theStockHolding value]];
        [portfolioValueField setDoubleValue:[portfolio value]];
        [priceField setDoubleValue:[theStockHolding stockPrice]];
        [sharesField setIntValue:[theStockHolding shares]];
        [tickerField setObjectValue:[theStockHolding tickerID]];
    } else {
        [self blankFields];
    }
}

- (void)blankFields
{
    [stockDisplayBox setTitle:@"Stock 0/0"];

    [nameField setObjectValue:@""];
    [assetValueField setDoubleValue:0.0];
    [portfolioValueField setDoubleValue:0.0];
    [priceField setDoubleValue:0.0];
    [sharesField setIntValue:0];
    [tickerField setObjectValue:@""];
}

@end
