/* Portfolio.h
 *
 * Portfolio is a class that keeps track of a number of Assets. It allows the user to
 * add Assets, delete Assets, or retrieve Assets by index. It also provides a value
 * method that returns the sum of the value of all Assets in the Portfolio. This method
 * calls the value method of each Asset in turn to compute the total value of the
 * Portfolio.
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <Foundation/NSObject.h>

@class Asset, NSArray, NSMutableArray;

@interface Portfolio : NSObject <NSCoding>
{
    NSMutableArray *assets;
}

- (id)init;
- (void)dealloc;

- (void)addAsset:(Asset *)anAsset;	// adds the Asset at the end of the array
- (void)removeAsset:(Asset *)anAsset;
- (void)removeAssetAtIndex:(int)index;
- (Asset *)assetAtIndex:(int)index;

- (int)numberOfAssets;

- (NSArray *)assets;

- (double)value;

@end
