/* Asset.h
 *
 * This class is an abstract superclass for different types of assets.
 * It declares one instance variable, the name of the asset, along with
 * supporting accessor methods. The value method as implemented in Asset
 * simply returns 0.0. Subclasses should override value to return the value
 * of the asset.
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <Foundation/NSObject.h>

@class NSString;

@interface Asset : NSObject <NSCoding>
{
    NSString *name;
}

- (id)init;
- (void)dealloc;

- (void)setName:(NSString *)aName;
- (NSString *)name;

- (double)value;

@end
