/* PortfolioController.h
 *
 * PortfolioController is the controller object for a Portfolio. It
 * handles the display of StockHoldings within a Portfolio, and allows
 * for creating and deleting StockHoldings, as well as updating their
 * values.
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <AppKit/AppKit.h>

@class Portfolio;

@interface PortfolioController : NSObject
{
    id assetValueField;
    id nameField;
    id portfolioValueField;
    id priceField;
    id sharesField;
    id tickerField;
    id stockDisplayBox;
    
    int displayedIndex;
    id portfolio;
}

- (id)init;
- (id)initWithPortfolio:(Portfolio *)aPortfolio;
- (void)dealloc;

- (void)setPortfolio:(Portfolio *)aPortfolio;
- (Portfolio *)portfolio;

- (void)deleteStock:(id)sender;
- (void)newStock:(id)sender;
- (void)nextStock:(id)sender;
- (void)previousStock:(id)sender;

- (void)saveChangesToSelection;
- (void)fillFields;
- (void)blankFields;

@end
