#import "HelloController.h"

static NSImage *sharedImage;

@implementation HelloController

- (void)sayHello:(id)sender
{
    [helloTextField setStringValue:@"Hello, world!"];
}

- (void)clearText:(id)sender
{
    [helloTextField setStringValue:@""];
}

- (void)encodeWithCoder:(NSCoder *)coder
{
    [coder encodeConditionalObject:helloTextField];
}

- (id)initWithCoder:(NSCoder *)coder
{
    helloTextField = [[coder decodeObject] retain];
    return self;
}

- (NSImage *)imageForViewer
{
    NSString *path;

    if (!sharedImage) {
        path = [[NSBundle bundleForClass:[self class]]
            pathForResource:@"HelloController" ofType:@"tiff"];
        sharedImage = [[NSImage alloc] initWithContentsOfFile:path];
    }
    return sharedImage;
}

@end