/* cpdfUtil.c -- tiny misc functions.
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

*/


#include "version.h"

#include <string.h>
#include <math.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"
#include "cglobals.h"

#ifdef MacOS8
#include <stat.mac.h>
#include <unix.mac.h>
#include <Memory.h>
#include <Strings.h>	/* c2pstr() */
extern size_t strlen(const char *s);
extern int strcmp(const char *s1, const char *s2);
extern void *memcpy(void *s1, const void *s2, size_t n);
#endif

/* ---------------------------------------------------------------------------------------- */
/* 3 x 3 matrix for CTM : z0 = z1 = 0, z2 = 1
typedef struct {
    float a; float b;
    float c; float d;
    float x; float y;
} CPDFctm;
*/

/* Will do matrix multiply: T = S x T 
   We use it to give Text CTM concatenation capability, as the "Tm" operator
   does not concatenate CTM, but sets the new one.
*/
void multiplyCTM(CPDFctm *T, const CPDFctm *S)
{
CPDFctm tempM, *T1;
    T1 = &tempM;	/* to avoid confusion, uniformly use -> */
    memcpy(T1, T, (size_t)sizeof(CPDFctm));
    /* using temp copy T1, we will do: T = S x T1
    */
    T->a = S->a * T1->a + S->b * T1->c;
    T->b = S->a * T1->b + S->b * T1->d;
    T->c = S->c * T1->a + S->d * T1->c;
    T->d = S->c * T1->b + S->d * T1->d;
    T->x = S->x * T1->a + S->y * T1->c + T1->x;
    T->y = S->x * T1->b + S->y * T1->d + T1->y;
}


/* Convert a float into M and E, where M * 10 ^ E, and 1 <= M < 10 */
float getMantissaExp(float v, int *iexp)
{
int ie = 0;
float vv = fabs(v);
    if(v == 0.0) {
	*iexp = 0;
	return(0.0);
    }

    while( vv >= 10.0) {
	vv /= 10.0;
	ie++;
    }
    while( vv < 1.0) {
	vv *= 10.0;
	ie--;
    }
    *iexp = ie;
    if(v>=0.0) return(vv);
    else       return(-vv);
}


void cpdf_useContentMemStream(int flag)
{
#ifdef EXT_ZLIBCOMP
	useContentMemStream = 0;	/* can't use external command if memory stream is used */
#else
	useContentMemStream = flag;
#endif

}


void cpdf_useStdout(int flag)
{
    useStandardOutput = flag;	/* send output to stdout if non-zero */
}

/* This function will set /Creator entry in the Info dictionary of the PDF file. */
void cpdf_setCreator(char *pname)
{
    strncpy(creator_name, pname, 62);
}

void cpdf_setTitle(char *pname)
{
    strncpy(file_title, pname, 62);
}

void cpdf_setSubject(char *pname)
{
    strncpy(file_subject, pname, 62);
}

void cpdf_setKeywords(char *pname)
{
    strncpy(file_keywords, pname, 126);
}

void cpdf_setPDFLevel(int major, int minor)
{
	pdfLevelMaj = major;
	pdfLevelMin = minor;
}

/* Other comments that can go anywhere in PS stream */
int cpdf_comments(char *comments) 
{
	if(comments != NULL) {
	    if(useContentMemStream)
		cpdf_writeMemoryStream(currentMemStream, comments, strlen(comments));
	    else
	        fprintf(fpcontent,"%s", comments);
	}
	return(0);
}

/* User must copy the string to retain it */
char *cpdf_getOutputFilename(void)
{
   return filenamepath;
}


/* this must be called before each call to cpdf_init() */
void cpdf_setOutputFilename(char *file)
{
    strncpy(filenamepath, file, 1022);
    filename_set  = 1;
    usePDFMemStream = 0;	/* do not use memory stream for PDF file itself */
}

void cpdf_setDefaultDomainUnit(float defunit)
{
    defdomain_unit = defunit;
}

/* private functions --------------------------------------------------------------------- */
void str_append_int(char *buf, int num)
{
char tnumbuf[64];
	sprintf(tnumbuf, "%d", num);
	strncat(buf, tnumbuf, 60);
}

void _cpdf_malloc_check(void *buf)
{
    if(!buf) {
	fprintf(stderr, "ClibPDF: Memory allocation failure\n");
	exit(-2);
    }
}

