/* cpdfFont.c  -- Font management and string width etc.
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

1998-07-11 [IO]
*/

/* #define DEBUG 	1 */

#include "version.h"

#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"		/* This must be included before all other local include files */
#include "cglobals.h"
#include "cpdfAFM.h"		/* font width array */

/* OK now */
float cpdf_stringWidth(unsigned char *str)
{
int i, indf = -1;
float swid = 0.0;
unsigned char *p;
int ch;
    /* find the basefont for the current font */
    for(i=0; i < NUMPSFONTS; i++) {
	if( strcmp(cpdf_fontnamelist[i], fontInfos[currentFont].baseFont) == 0) {
	    indf = i;
	    break;
	}
    }
    if(indf < 0) {
	fprintf(stderr, "ClibPDF: no font has been set.\n");
	return(5.0);	/* return just an arbitrary number */
    }
    p = str;
    while((ch = *p++) != '\0') {
	swid += font_size * (float)(charWidth[indf][ch])/1000.0 + char_spacing;
	if(ch == ' ')
	    swid += word_spacing;
    }
    swid -= char_spacing;		/* spacing between chars is one less */
    swid *= horiz_scaling/100.0;

#ifdef DEBUG
    printf("%g inches: %s\n", swid/72.0, str);
#endif
    return(swid);
}


int cpdf_setFont(char *basefontname, char *encodename, float size)
{
int i, fontOK= 0;
int foundInPageList = 0;	/* in pageInfos[].fontIdx[] */
int fontIndexFound = 0;		/* in fontInfos[] */
char *realbasefont;
CPDFfontInfo *newFont;
char fontname[32], *font;
    realbasefont = basefontname;
    for(i=0; i<NUMPSFONTS; i++) {
	if( strcmp(basefontname, cpdf_fontnamelist[i]) == 0) {
	    fontOK = 1;
	    break;
	}
    }
    if(!fontOK) {
	fprintf(stderr, "ClibPDF: Bad font not in 14 base PostScript fonts: %s\n", basefontname);
	fprintf(stderr, ">> substituting Times-Roman.\n");
	realbasefont = "Times-Roman";
    }

    /* check if this font has already been included or new font */
    if( isNewFont(realbasefont, encodename, &fontIndexFound) ) {
	if(numFonts >= NMAXFONTS) {
	    fprintf(stderr, "ClibPDF: Too many fonts. Increase NMAXFONTS in cpdflib.h and recompile library.\n");
	    return(1);
	}
        sprintf(fontname, "Fcpdf%d", numFonts);
	font = fontname;
	newFont = &fontInfos[numFonts];
	currentFont = numFonts;			/* index of curren font */
	newFont->name = (char *)malloc((size_t)(strlen(fontname) + 1));
	_cpdf_malloc_check((void *)newFont->name);
	newFont->baseFont = (char *)malloc((size_t)(strlen(realbasefont) + 1));
	_cpdf_malloc_check((void *)newFont->baseFont);
	newFont->encoding = (char *)malloc((size_t)(strlen(encodename) + 1));
	_cpdf_malloc_check((void *)newFont->encoding);
	strcpy(newFont->name, fontname);
	strcpy(newFont->baseFont, realbasefont);
	strcpy(newFont->encoding, encodename);
	numFonts++;
    }
    else {
	/* This font has been used already, and is in fontInfos[fontIndexFound] */
	currentFont = fontIndexFound;		/* index of curren font */
	font = fontInfos[fontIndexFound].name;
    }

    /*  Store the index of this font in the used font list in pageInfos[].
	Multiple pages can share fonts.
    */
    foundInPageList = 0;
    for(i=0; i < pageInfos[currentPage].npFont; i++) {
	if(pageInfos[currentPage].fontIdx[i] == currentFont)
	    foundInPageList = 1;
    }
    if(!foundInPageList)
        pageInfos[currentPage].fontIdx[pageInfos[currentPage].npFont++] = currentFont;

    /* Write font spec line to Contents stream */
    inTextObj = 1;
    if(useContentMemStream) {
	sprintf(spbuf, "/%s %.3f Tf\n", font, size);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
        fprintf(fpcontent, "/%s %.3f Tf\n", font, size);
    font_size = size;
    
    return(0);
}


int isNewFont(char *basefontname, char *encodename, int *fontFound)
{
int i, isNew = 1;
    /* look in the list */
    for(i=0; i < numFonts; i++) {
	if( (strcmp(basefontname, fontInfos[i].baseFont) == 0) &&
	    (strcmp(encodename, fontInfos[i].encoding) == 0) ) {
	    isNew = 0;		/* already defined */
	    *fontFound = i;	/* return found font index */
	    break;
	}
    }
    if(isNew)
	*fontFound = numFonts;	/* index of the new font */
    return(isNew);
}


int  _cpdf_freeAllFontInfos(void)
{
CPDFfontInfo *tfont;
int i;
    for(i=0; i< numFonts; i++) {
	tfont = &fontInfos[i];
	if(tfont->name) {
	    free(tfont->name);
	    tfont->name = NULL;
	}
	if(tfont->baseFont) {
	    free(tfont->baseFont);
	    tfont->baseFont = NULL;
	}
	if(tfont->encoding) {
	    free(tfont->encoding);
	    tfont->encoding = NULL;
	}
    }
    return(0);
}


