/*$Id: SenUtilities.h,v 1.2 1998/12/20 16:40:37 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import <Foundation/Foundation.h>
#import "SenFoundationDefines.h"
#import "SenAssertion.h"


// RETAIN should be used in -set... methods instead of the Apple 
// promoted pattern (autorelease / retain). It is faster and 
// semantically more correct.
// newVal is to avoid multiple evaluations of val.

#define RETAIN(var,val) \
do { \
    id newVal = (val); \
    if (var != newVal) { \
        if (var) { \
            [var release]; \
        } \
        if (newVal) { \
            [newVal retain]; \
        } \
        var = newVal; \
    } \
} while (0)

// Like RETAIN above, CHANGE_RETAIN should be used in -set... methods 
// instead of the Apple promoted pattern (autorelease / retain).
// CHANGE_RETAIN sends willChange to self, but only if the variable 
// is really changed.

@protocol Changes
- (void) willChange;
@end

#define SELF_WILL_CHANGE \
do { \
        [(id <Changes>) self willChange]; \
} while (0)


#define CHANGE_RETAIN(var,val) \
do { \
    id newVal = (val); \
    if (var != newVal) { \
        SELF_WILL_CHANGE; \
        if (var) { \
            [var release]; \
        } \
        if (newVal) { \
            [newVal retain]; \
        } \
        var = newVal; \
    } \
} while (0)


// The RELEASE macro can be used in any place where a release 
// message would be sent. VAR is released and set to nil
#define RELEASE(var) \
do { \
    if (var) { \
        [(id) var release]; \
        var = nil; \
    } \
} while (0)


// Protected type casting
#define AsKindOfClass(_class,_object) \
({ \
    id _val = (_object); \
    senassert((_val == nil) || [_val isKindOfClass:[_class class]]); \
    (_class *) _val; \
})


#define AsConformingToProtocol(_protocol,_object) \
({ \
    id _val = (_object); \
    senassert((_val == nil) || [_val conformsToProtocol:@protocol(_protocol)]); \
    (id <_protocol>) _val; \
})


// Miscellaneous constants and predicates
SENFOUNDATION_EXPORT NSRange SenRangeNotFound;

#define isEmptyStringRange(x)          ((x).length == 0)
#define isFoundStringRange(x)          ((x).length > 0)
#define isValidTextRange(x)            ((x).location != NSNotFound)

#define SenDefaultNotificationCenter   [NSNotificationCenter defaultCenter]
#define SenDefaultUserDefaults         [NSUserDefaults standardUserDefaults]
#define SenDefaultFileManager          [NSFileManager defaultManager]
#define SenDefaultNotificationQueue    [NSNotificationQueue defaultQueue]
#define SenDefaultTimeZone             [NSTimeZone defaultTimeZone]
