/*$Id: NSObject_SenRuntimeUtilities.m,v 1.2 1998/12/20 16:40:18 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "NSObject_SenRuntimeUtilities.h"
#import "SenEmptiness.h"
#import "SenAssertion.h"
#import "SenCollection.h"
#import "SenInvocationEnumerator.h"
#import "SenClassEnumerator.h"
#import <Foundation/Foundation.h>

NSString *SenMethodName (id self, SEL _cmd)
{
    return [NSString stringWithFormat:@"%c[%@ %@]", (self == [self class]) ? "+" : "-", [self class], NSStringFromSelector(_cmd)];
}


@interface NSObject (SenPrivateRuntimeUtilities)
+ (BOOL) isASubclassOfClass:(Class) aClass;
+ (BOOL) isASuperclassOfClass:(Class) aClass;
@end


@implementation NSObject (SenRuntimeUtilities)
+ (NSEnumerator *) instanceInvocationEnumerator
{
    return [SenInvocationEnumerator instanceInvocationEnumeratorForClass:self];
}


+ (NSEnumerator *) classEnumerator
{
    return [SenClassEnumerator classEnumerator];
}


+ (NSString *) className
{
    return NSStringFromClass (self);
}


- (NSString *) className
{
    return NSStringFromClass ([self class]);
}


+ (NSArray *) allSuperclasses
{
    static NSMutableDictionary *superclassesClassVar = nil;
    NSString *key = NSStringFromClass (self);

    if (superclassesClassVar == nil) {
        superclassesClassVar = [[NSMutableDictionary alloc] init];
    }
    if ([superclassesClassVar objectForKey:key] == nil) {
        NSMutableArray *superclasses = [NSMutableArray array];
        Class currentClass = self;
        while (currentClass != nil) {
            [superclasses addObject:currentClass];
            currentClass = [currentClass superclass];
        }
        [superclassesClassVar setObject:superclasses forKey:key];
    }
    return [superclassesClassVar objectForKey:key];
}


- (NSArray *) allSuperclasses
{
    return [[self class] allSuperclasses];
}


+ (NSArray *) allSuperclassNames
{
    return [[[self allSuperclasses] collectionByPerformingSelector:@selector(className)] asArray];
}


- (NSArray *) allSuperclassNames
{
    return [[[self allSuperclasses] collectionByPerformingSelector:@selector(className)] asArray];
}


+ (BOOL) isASubclassOfClass:(Class) aClass
{
    return  (aClass != self) && [[self allSuperclasses] containsObject:aClass];
}

+ (BOOL) isASuperclassOfClass:(Class) aClass
{
    // respondsToSelector is needed when aClass does not inherit from NSObject.
    return  (aClass != self) && [aClass respondsToSelector:@selector(allSuperclasses)] && [[aClass allSuperclasses] containsObject:self];
}


+ (BOOL) hasIgnoredPrefix:(NSString *) aString
{
    static NSSet *ignoredPrefixes = nil;
    NSEnumerator *ignoredPrefixEnumerator;
    NSString *each;

    if (ignoredPrefixes == nil) {
        ignoredPrefixes = [[NSSet setWithObjects:@"NSFramework_", @"NSZombie", @"NX", nil] retain];
    }
    ignoredPrefixEnumerator = [ignoredPrefixes objectEnumerator];
    while (each = [ignoredPrefixEnumerator nextObject]) {
        if ([aString hasPrefix:each]) {
            return YES;
        }
    }
    return NO;
}


+ (NSArray *) allSubclasses
{
    NSMutableArray *subclasses = [NSMutableArray array];
    NSEnumerator *classEnumerator = [self classEnumerator];
    id eachClass = nil;

    while (eachClass = [classEnumerator nextObject]) {
        // These cases wreak havoc
        NSString *className = NSStringFromClass (eachClass);
        if ([self hasIgnoredPrefix:className]) {
            SEN_DEBUG (([NSString stringWithFormat:@"Skipping %@", className]));
            continue;
        }
        
        NS_DURING
            if ([self isASuperclassOfClass:eachClass]) {
                [subclasses addObject:eachClass];
            };
        NS_HANDLER
            SEN_DEBUG (([NSString stringWithFormat:@"Skipping %@", className]));
        NS_ENDHANDLER
    }
    return [subclasses isEmpty] ? nil : subclasses;
}


+ (NSArray *) allSubclassNames;
{
    return [[[self allSubclasses] collectionByPerformingSelector:@selector(className)] asArray];
}


- (NSArray *) allSubclasses
{
    return [[self class] allSubclasses];
}


- (NSArray *) allSubclassNames
{
    return [[[self allSubclasses] collectionByPerformingSelector:@selector(className)] asArray];
}
@end
