/*$Id: SenTestSuiteRun.m,v 1.1 1998/12/20 16:51:49 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestSuiteRun.h"
#import <Foundation/Foundation.h>
#import <SenFoundation/SenFoundation.h>

@implementation SenTestSuiteRun
- (id) initWithTest:(SenTest *) aTest
{
    self = [super initWithTest:aTest];
    runs = [[NSMutableArray alloc] init];
    return self;
}


- (void) dealloc
{
    RELEASE (runs);
    [super dealloc];
}


- (id) initWithCoder:(NSCoder *) aCoder
{
    [super initWithCoder:aCoder];
    runs = [[aCoder decodeObject] mutableCopy];
    return self;
}


- (void) encodeWithCoder:(NSCoder *) aCoder
{
    [super encodeWithCoder:aCoder];
    [aCoder encodeObject:[self testRuns]];
}


- (void) start
{
    [super start];
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestSuiteDidStartNotification object:self];
}


- (void) stop
{
    [super stop];
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestSuiteDidStopNotification object:self];
}



- (NSArray *) testRuns
{
    return runs;
}


- (void) addTestRun:(SenTestRun *) aTestRun
{
    [runs addObject:aTestRun];
}


- (unsigned int) failureCount
{
    return [runs sumWithUnsignedIntSelector:_cmd];
}


- (unsigned int) errorCount
{
    return [runs sumWithUnsignedIntSelector:_cmd];
}

- (NSTimeInterval) testDuration
{
    return [runs sumWithDoubleSelector:_cmd];
}

@end

NSString *SenTestSuiteDidStartNotification = @"SenTestSuiteDidStartNotification";
NSString *SenTestSuiteDidStopNotification = @"SenTestSuiteDidStopNotification";
