/*$Id: NSException_SenTestFailure.m,v 1.2 1998/12/20 16:51:16 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "NSException_SenTestFailure.h"
#import "SenTestCase.h"
#import <SenFoundation/SenFoundation.h>
#import <Foundation/Foundation.h>

@implementation NSException (SenTestFailure)

- (NSString *) filename
{
    return [[self userInfo] objectForKey:SenTestFilenameKey];
}

- (NSSet *) ignoredSubdirectories
{
    static NSSet *ignoredSubdirectories = nil;
    if (ignoredSubdirectories == nil) {
        NSString *path = [[NSBundle bundleForClass:[SenTestCase class]] pathForResource:@"BuildExtensions" ofType:@"plist"];
        ignoredSubdirectories = [[NSSet setWithArray:[[NSString stringWithContentsOfFile:path] propertyList]] retain];
    }
    return ignoredSubdirectories;
}


- (NSString *) pathForFilename:(NSString *) aFilename
{
    if (isNilOrEmpty (aFilename)){
        return @"Unknown file";
    }
    else {
        NSFileManager *fileManager = SenDefaultFileManager;
        NSString *currentDirectory = [fileManager currentDirectoryPath];
        NSString *projectPath = [[NSArray arrayWithObjects:currentDirectory, @"PB.project", nil] componentsJoinedByString:@"/"];

        if ([fileManager fileExistsAtPath:projectPath]) {
            NSDirectoryEnumerator *directoryEnumerator = [fileManager enumeratorAtPath:currentDirectory];
            NSString *each = nil;
            while (each = [directoryEnumerator nextObject]){
                if ([[self ignoredSubdirectories] containsObject:[each pathExtension]]) {
                    [directoryEnumerator skipDescendents];
                }
                else if ([[each lastPathComponent] isEqualToString:aFilename]) {
                    return each;
                }
            }
        }
        return aFilename;
    }
}


- (NSString *) filePathInProject
{
    return [self pathForFilename:[self filename]];
}


- (NSNumber *) lineNumber
{
    return [[self userInfo] objectForKey:SenTestLineNumberKey];
}


+ (NSException *) failureInCondition:(NSString *) condition isTrue:(BOOL) isTrue inFile:(NSString *) filename atLine:(int) lineNumber
{
    return [self exceptionWithName:SenTestFailureException

                                   reason:[NSString stringWithFormat:@"%@ should be %@", condition, isTrue ? @"false" : @"true"]

                                 userInfo:[NSDictionary dictionaryWithObjectsAndKeys:
                                     SenConditionFailure, SenFailureTypeKey,
                                     condition, SenTestConditionKey,
                                     filename, SenTestFilenameKey,
                                     [NSNumber numberWithInt:lineNumber], SenTestLineNumberKey,
                                     nil]];
}


+ (NSException *) failureInEqualityBetween:(id) left and:(id) right inFile:(NSString *) filename atLine:(int) lineNumber
{
    return [self exceptionWithName:SenTestFailureException

                             reason:[NSString stringWithFormat:@"%@ should be equal to %@",
                                 [left description],
                                 [right description]]

                           userInfo:[NSDictionary dictionaryWithObjectsAndKeys:
                               SenEqualityFailure, SenFailureTypeKey,
                               left, SenTestEqualityLeftKey,
                               right, SenTestEqualityRightKey,
                               filename, SenTestFilenameKey,
                               [NSNumber numberWithInt:lineNumber], SenTestLineNumberKey,
                               nil]];
}


+ (NSException *) failureInRaise:(NSString *) expression inFile:(NSString *) filename atLine:(int) lineNumber
{
    return [self exceptionWithName:SenTestFailureException

                             reason:[NSString stringWithFormat:@"%@ should raise", expression]

                           userInfo:[NSDictionary dictionaryWithObjectsAndKeys:
                               SenRaiseFailure, SenFailureTypeKey,
                               expression, SenTestConditionKey,
                               filename, SenTestFilenameKey,
                               [NSNumber numberWithInt:lineNumber], SenTestLineNumberKey,
                               nil]];
}
@end


NSString *SenTestFailureException = @"SenTestFailureException";

NSString *SenFailureTypeKey = @"type";
NSString *SenConditionFailure = @"condition";
NSString *SenEqualityFailure = @"equality";
NSString *SenRaiseFailure = @"raise";

NSString *SenTestConditionKey = @"condition";
NSString *SenTestEqualityLeftKey = @"left";
NSString *SenTestEqualityRightKey = @"right";

NSString *SenTestFilenameKey = @"filename";
NSString *SenTestLineNumberKey = @"linenumber";
