/*$Id: NSException_SenTestFailure.h,v 1.2 1998/12/20 16:51:15 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import <Foundation/Foundation.h>
#import "SenTestDefines.h"

@interface NSException (SenTestFailure)

- (NSString *) filename;
- (NSString *) filePathInProject;
- (NSNumber *) lineNumber;

+ (NSException *) failureInCondition:(NSString *) condition isTrue:(BOOL) isTrue inFile:(NSString *) filename atLine:(int) lineNumber;
+ (NSException *) failureInEqualityBetween:(id) left and:(id) right  inFile:(NSString *) filename atLine:(int) lineNumber;
+ (NSException *) failureInRaise:(NSString *) expression inFile:(NSString *) filename atLine:(int) lineNumber;

@end


SENTEST_EXPORT NSString * const SenTestFailureException;

SENTEST_EXPORT NSString * const SenFailureTypeKey;

SENTEST_EXPORT NSString * const SenConditionFailure;
SENTEST_EXPORT NSString * const SenRaiseFailure;
SENTEST_EXPORT NSString * const SenEqualityFailure;

SENTEST_EXPORT NSString * const SenTestConditionKey;
SENTEST_EXPORT NSString * const SenTestEqualityLeftKey;
SENTEST_EXPORT NSString * const SenTestEqualityRightKey;
SENTEST_EXPORT NSString * const SenTestFilenameKey;
SENTEST_EXPORT NSString * const SenTestLineNumberKey;
