/* 
	PrefsController.m created by dirk on Wed 13-Oct-1999
*/
#import "PrefsController.h"
#import "AppController.h"
#import "Mailbox.h"
#import "globals.h"

@implementation PrefsController : NSWindowController

- (id)init
{
    self = [self initWithWindowNibName:@"Preferences"];
    return self;
}

//------------------------------------------------------------------------------
// NSWindowController messages
//------------------------------------------------------------------------------
- (void)showWindow:(id)sender
{
    [self window]; // will load NIB if necessary
    [super showWindow:sender];
}

- (void)windowDidLoad
{
    NSUserDefaults	*defaults;

    defaults = [NSUserDefaults standardUserDefaults];
    [ibIntervalTextField setIntValue:[defaults integerForKey:gvUpdateTimerInterval]];
    [ibCheckMailboxesButton setState:[defaults boolForKey:gvCheckOnActivate]];
}

//------------------------------------------------------------------------------
// Action methods
//------------------------------------------------------------------------------
- (void)removeMailboxFromList:(id)sender
{
    [[ivAppController mailboxArray] removeObjectAtIndex:[ibTableView selectedRow]];
    [ibTableView reloadData];
}

- (void)addMailboxToList:(id)sender
{
    NSOpenPanel		*openPanel;
    int				result;

    openPanel = [NSOpenPanel openPanel];
    [openPanel setAllowsMultipleSelection:YES];
    result = [openPanel runModalForDirectory:[Mailbox mailViewerMailboxPath] file:nil types:[NSArray arrayWithObject:@"mbox"]];
    if (result == NSOKButton)
    {
        NSEnumerator	*mboxEnum;
        NSString		*mboxPath;

        mboxEnum = [[openPanel filenames] objectEnumerator];
        while ((mboxPath = [mboxEnum nextObject]) != nil)
        {
            Mailbox			*newMailbox;

            newMailbox = [[[Mailbox alloc] initWithMailboxPath:mboxPath] autorelease];
            [ivAppController addToMailboxArray:newMailbox];
            [ibTableView reloadData];
        }
    }
}

- (void)updatePreferences:(id)sender;
{
    NSUserDefaults	*defaults;

    defaults = [NSUserDefaults standardUserDefaults];
    [defaults setInteger:[ibIntervalTextField intValue] forKey:gvUpdateTimerInterval];
    [defaults setBool:[ibCheckMailboxesButton intValue] forKey:gvCheckOnActivate];
    [defaults synchronize];

    // restart the timer since the time interval might have changed
    [ivAppController setTimer:[NSTimer scheduledTimerWithTimeInterval:[ibIntervalTextField intValue] target:ivAppController selector:@selector(updateTocs:) userInfo:nil repeats:YES]];

    // make sure the new selection of mailboxes to watch is saved to the userDefaults
    [ivAppController saveWatchedMailboxes];
        
    [[self window] close];
}

- (void)cancel:(id)sender
{
    [[self window] close];
}

@end

@implementation PrefsController (TableViewSupport)

//------------------------------------------------------------------------------
// TableView DataSource
//------------------------------------------------------------------------------
- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
{
    return [[ivAppController mailboxArray] count];
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;
{
    return [[[ivAppController mailboxArray] objectAtIndex:rowIndex] mailboxPath];
}

@end
