//---------------------------------------------------------------------------------------
//	SPCTileView.m created by erik on Tue 28-Jul-1998
//	This code is part of the Spectre Project by Erik Doernenburg. For copyright details
//	see GNU public license version 2 or above. No warranties implied. Use at own risk.
//	More information can be found at <http://www.object-factory.com/~erik/Spectre>.
//	@(#)$Id: SPCTileView.m,v 1.3 1998/09/27 21:19:35 erik Exp $
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import "SPCTileView.h"

//---------------------------------------------------------------------------------------
    @implementation SPCTileView
//---------------------------------------------------------------------------------------

static NSImage *tileImage = nil;
static NSImage *launchMaskImage = nil;
static NSImage *notRunningMaskImage = nil;


//---------------------------------------------------------------------------------------
//	CLASS ATTRIBUTES (also used for initialisation)
//---------------------------------------------------------------------------------------

+ (NSSize)tileSize;
{
    if(tileImage == nil)
        {
        tileImage = [[NSImage imageNamed:@"BlankTile"] retain];
        NSAssert(tileImage != nil, @"missing resource; cannot find image BlankTile");
        launchMaskImage = [[NSImage imageNamed:@"LaunchMask"] retain];
        NSAssert(launchMaskImage != nil, @"missing resource; cannot find image LaunchMask");
        notRunningMaskImage = [[NSImage imageNamed:@"NotRunningMask"] retain];
        NSAssert(notRunningMaskImage != nil, @"missing resource; cannot find image NotRunningMask");
        }
    return [tileImage size];
}


- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
    return YES;
}

//---------------------------------------------------------------------------------------
//	INIT & DEALLOC
//---------------------------------------------------------------------------------------

- (id)initWithFrame:(NSRect)frameRect
{
    [super initWithFrame:frameRect];

    [isa tileSize];
    appState = NSWorkspaceDidTerminateApplicationNotification;
    [self registerForDraggedTypes:[NSArray arrayWithObject:NSFilenamesPboardType]];

    return self;
}


- (void)dealloc
{
    [appPath release];
    [appIcon release];
    [super dealloc];
}


//---------------------------------------------------------------------------------------
//	ACCESSOR METHODS
//---------------------------------------------------------------------------------------

- (void)setAppPath:(NSString *)aPath;
{
    float 	x, y;

    [appPath autorelease];
    appPath = [aPath copyWithZone:[self zone]];

    [appIcon autorelease];
    appIcon = [[[NSWorkspace sharedWorkspace] iconForFile:appPath] retain];

    x = ([tileImage size].width - [appIcon size].width) / 2;
    y = ([tileImage size].height - [appIcon size].height) / 2;
    imageOrigin = NSMakePoint(x, y);

    [self setNeedsDisplay:YES];
}

- (NSString *)appPath;
{
    return appPath;
}


- (void)setAppState:(NSString *)newState;
{
    appState = newState;
    [self display];
    [[self window] flushWindowIfNeeded];
    [[NSDPSContext currentContext] flush];
}

- (NSString *)appState;
{	
    return appState;
}


- (void)setTarget:(id)anObject;
{
    target = anObject;
}

- (id)target;
{
    return target;
}


- (void)setAction:(SEL)aSelector;
{
    action =  aSelector;
}

- (SEL)action;
{
    return action;
}


- (void)setDoubleAction:(SEL)aSelector;
{
    doubleAction =  aSelector;
}

- (SEL)doubleAction;
{
    return doubleAction;
}

- (void)setAltAction:(SEL)aSelector;
{
    altAction = aSelector;
}

- (SEL)altAction;
{
    return altAction;
}

- (void)setDoubleCommandAction:(SEL)aSelector;
{
    doubleCommandAction =  aSelector;
}

- (SEL)doubleCommandAction;
{
    return doubleCommandAction;
}


- (void)setDelegate:(id)anObject;
{
    delegate = anObject;
    flags.delegateRespondsToDrop = [anObject respondsToSelector:@selector(tileView:acceptedDroppedPath:)];
}

- (id)delegate;
{
    return delegate;
}


//---------------------------------------------------------------------------------------
//	DRAWING
//---------------------------------------------------------------------------------------

- (void)drawRect:(NSRect)aRect
{
    [tileImage compositeToPoint:NSZeroPoint operation:NSCompositeCopy];
    if(appState == NSWorkspaceDidTerminateApplicationNotification)
        [notRunningMaskImage compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver];
    [appIcon compositeToPoint:imageOrigin operation:NSCompositeSourceOver];
    if(appState == NSWorkspaceWillLaunchApplicationNotification)
       [launchMaskImage compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver];
}


//---------------------------------------------------------------------------------------
//	EVENT HANDLING
//---------------------------------------------------------------------------------------

- (void)mouseDown:(NSEvent *)theEvent
{
    unsigned int modifierFlags = [theEvent modifierFlags];
    
    if([theEvent clickCount] == 1)
        {
        if((modifierFlags & NSAlternateKeyMask) != 0)
            {
            if(altAction != NULL)
                [target performSelector:altAction withObject:self];
            }
        else
            {
            if(action != NULL)
                [target performSelector:action withObject:self];
            }
        }
    else if([theEvent clickCount] == 2)
        {
        if((modifierFlags & NSCommandKeyMask) != 0)
            {
            if(doubleCommandAction != NULL)
                [target performSelector:doubleCommandAction withObject:self];
            }
        else
            {
            if(doubleAction != NULL)
                [target performSelector:doubleAction withObject:self];
            }
      }
}


//---------------------------------------------------------------------------------------
//	DRAGGING DEST
//---------------------------------------------------------------------------------------

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
    if(flags.delegateRespondsToDrop == NO)
        return NSDragOperationNone;

    return [sender draggingSourceOperationMask] & NSDragOperationGeneric;
}


- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
    return flags.delegateRespondsToDrop;
}


- (void)concludeDragOperation:(id <NSDraggingInfo>)sender
{
    NSPasteboard *pboard;
    NSEnumerator *pathEnum;
    NSString	 *path;

    pboard = [sender draggingPasteboard];
    if([[pboard types] indexOfObject:NSFilenamesPboardType] != NSNotFound)
        {
        pathEnum = [[pboard propertyListForType:NSFilenamesPboardType] objectEnumerator];
        while((path = [pathEnum nextObject]) != nil)
            [delegate tileView:self acceptedDroppedPath:path];
        }
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------
